/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.google.common.collect.Lists;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jar.oa.wrapper.WorkflowHandler;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.UserWorkflowHandler;
import com.jz.jooq.oa.tables.records.UserWorkflowHandlerRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserWorkflowHandlerRepository
extends OABaseRepository {
    private static final UserWorkflowHandler HANDLER = Tables.USER_WORKFLOW_HANDLER;

    public void addUserWorkflowHandlers(String identify, Collection<WorkflowHandler> handlers) {
        long timeMillis = System.currentTimeMillis();
        ArrayList handlerRecords = Lists.newArrayList();
        for (WorkflowHandler workflowHandler : handlers) {
            if (workflowHandler.getIsCarbonCopy().booleanValue()) continue;
            UserWorkflowHandlerRecord handlerRecord = new UserWorkflowHandlerRecord();
            handlerRecord.setUwfid(identify);
            handlerRecord.setUid(workflowHandler.getUid());
            handlerRecord.setHandleName(workflowHandler.getHandleName());
            handlerRecord.setStep(workflowHandler.getStep());
            handlerRecord.setExtType(workflowHandler.getExtType());
            handlerRecord.setLastUpdate(Long.valueOf(timeMillis));
            handlerRecords.add(handlerRecord);
        }
        this.oaCtx.batchInsert((Collection)handlerRecords).execute();
    }

    public List<com.jz.jooq.oa.tables.pojos.UserWorkflowHandler> getUserWorkflowHandleInfos(String identify) {
        return this.oaCtx.selectFrom((Table)HANDLER).where(new Condition[]{UserWorkflowHandlerRepository.HANDLER.UWFID.eq((Object)identify)}).orderBy(UserWorkflowHandlerRepository.HANDLER.STEP.asc()).fetchInto(com.jz.jooq.oa.tables.pojos.UserWorkflowHandler.class);
    }

    public void updateHandleInfo(String identify, String uid, Integer step, String position, UserWorkflow result, String remarks) {
        this.oaCtx.update((Table)HANDLER).set((Field)UserWorkflowHandlerRepository.HANDLER.POSITION_NAME, (Object)position).set((Field)UserWorkflowHandlerRepository.HANDLER.RESULT, (Object)result.getCode()).set((Field)UserWorkflowHandlerRepository.HANDLER.REMARKS, (Object)remarks).set((Field)UserWorkflowHandlerRepository.HANDLER.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{UserWorkflowHandlerRepository.HANDLER.UWFID.eq((Object)identify).and(UserWorkflowHandlerRepository.HANDLER.UID.eq((Object)uid)).and(UserWorkflowHandlerRepository.HANDLER.STEP.eq((Object)step))}).execute();
    }

    public void addUserWorkflowHandler(String identify, String uid, String handleName, int step, String reason) {
        UserWorkflowHandlerRecord handlerRecord = new UserWorkflowHandlerRecord();
        handlerRecord.setUwfid(identify);
        handlerRecord.setUid(uid);
        handlerRecord.setHandleName(handleName);
        handlerRecord.setStep(Integer.valueOf(step));
        handlerRecord.setReason(reason);
        handlerRecord.setLastUpdate(Long.valueOf(System.currentTimeMillis()));
        this.oaCtx.insertInto((Table)HANDLER).set((Record)handlerRecord).execute();
    }

    public com.jz.jooq.oa.tables.pojos.UserWorkflowHandler getUserWorkflowHandleInfo(String identify, String uid, Integer step) {
        return (com.jz.jooq.oa.tables.pojos.UserWorkflowHandler)this.oaCtx.selectFrom((Table)HANDLER).where(new Condition[]{UserWorkflowHandlerRepository.HANDLER.UWFID.eq((Object)identify).and(UserWorkflowHandlerRepository.HANDLER.UID.eq((Object)uid)).and(UserWorkflowHandlerRepository.HANDLER.STEP.eq((Object)step))}).fetchAnyInto(com.jz.jooq.oa.tables.pojos.UserWorkflowHandler.class);
    }

    public boolean isExistCurrentUser(String identify, String uid) {
        return this.oaCtx.fetchExists((Table)HANDLER, UserWorkflowHandlerRepository.HANDLER.UWFID.eq((Object)identify).and(UserWorkflowHandlerRepository.HANDLER.UID.eq((Object)uid)));
    }

    public void cleanUserWorkflowHandles(String identify) {
        this.oaCtx.deleteFrom((Table)HANDLER).where(new Condition[]{UserWorkflowHandlerRepository.HANDLER.UWFID.eq((Object)identify)}).execute();
    }

    public List<String> getHandledByMe(String uid, int code, List<String> allUwfids) {
        return this.oaCtx.select((SelectField)UserWorkflowHandlerRepository.HANDLER.UWFID).from((TableLike)HANDLER).where(new Condition[]{UserWorkflowHandlerRepository.HANDLER.UWFID.in(allUwfids).and(UserWorkflowHandlerRepository.HANDLER.UID.eq((Object)uid).and(UserWorkflowHandlerRepository.HANDLER.RESULT.eq((Object)code)))}).fetchInto(String.class);
    }
}

