package com.jz.jar.oa.cache;

import java.util.Calendar;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.jz.common.utils.datetime.TimeTools;
import com.jz.common.utils.text.StringTools;

import redis.clients.jedis.JedisCluster;

/**
 * @Title WorkflowIdentifyCache
 * @Package com.jz.oa.cache
 * @author tangjunfeng
 * @date 2019年3月27日 下午2:54:05
 * @version V1.0
 */
@Component
public class WorkflowIdentifyCache {

	private static final Logger logger = LoggerFactory.getLogger(WorkflowIdentifyCache.class);
	// 1 day
	private static final int seconds = 86400;

	@Autowired
	private JedisCluster jedisCluster;

	private String getTempKey() {
		String today = TimeTools.getDateTime(Calendar.getInstance().getTimeInMillis(), "yyyyMMdd");
		return new StringBuffer("workflow:identity:").append(today).toString();
	}

	public String getWorkflowIdentity() {
		try {
			String tempKey = getTempKey();
			Long incr = jedisCluster.incr(tempKey);
			jedisCluster.expire(tempKey, seconds);
			return incr.toString();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return StringTools.RandomString.numbers(7);
		}
	}
}
