/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.WorkAddress;
import com.jz.jooq.oa.tables.records.WorkAddressRecord;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class OAWorkAddressRepository
extends OABaseRepository {
    private static final WorkAddress WD = Tables.WORK_ADDRESS;

    public List<com.jz.jooq.oa.tables.pojos.WorkAddress> getAllWorkAddress() {
        return this.oaCtx.selectFrom((Table)WD).fetchInto(com.jz.jooq.oa.tables.pojos.WorkAddress.class);
    }

    public List<com.jz.jooq.oa.tables.pojos.WorkAddress> mutiWorkAddress(Collection<String> workAddrIds) {
        return this.oaCtx.selectFrom((Table)WD).where(new Condition[]{OAWorkAddressRepository.WD.ID.in(workAddrIds)}).fetchInto(com.jz.jooq.oa.tables.pojos.WorkAddress.class);
    }

    public com.jz.jooq.oa.tables.pojos.WorkAddress getWorkAddress(String workAddrId) {
        return (com.jz.jooq.oa.tables.pojos.WorkAddress)this.oaCtx.selectFrom((Table)WD).where(new Condition[]{OAWorkAddressRepository.WD.ID.eq((Object)workAddrId)}).fetchAnyInto(com.jz.jooq.oa.tables.pojos.WorkAddress.class);
    }

    public boolean checkName(String name) {
        return this.oaCtx.fetchExists((Table)WD, OAWorkAddressRepository.WD.NAME.eq((Object)name));
    }

    public void createWorkAddress(String id, String name, String address, String timekeeper, String workday, Integer flexible, Double floatHour, String checkin, String checkout) {
        this.oaCtx.insertInto((Table)WD).set((Record)new WorkAddressRecord(id, name, address, timekeeper, workday, checkin, checkout, flexible, floatHour != null ? new BigDecimal(floatHour) : null, Long.valueOf(System.currentTimeMillis()))).execute();
    }

    public void updateWorkAddress(String id, String name, String address, String timekeeper, String workday, Integer flexible, Double floatHour, String checkin, String checkout) {
        WorkAddressRecord record = new WorkAddressRecord();
        record.setName(name);
        record.setAddress(address);
        record.setTimekeeper(timekeeper);
        record.setWorkday(workday);
        record.setCheckin(checkin);
        record.setCheckout(checkout);
        record.setFlexible(flexible);
        if (floatHour != null) {
            record.setFloatHour(new BigDecimal(floatHour));
        }
        this.oaCtx.update((Table)WD).set((Record)record).where(new Condition[]{OAWorkAddressRepository.WD.ID.eq((Object)id)}).execute();
    }

    public void deleteWorkAddress(String id) {
        this.oaCtx.deleteFrom((Table)WD).where(new Condition[]{OAWorkAddressRepository.WD.ID.eq((Object)id)}).execute();
    }

    public void updateTimekeeper(String currentlyKeeper, String newKeeper) {
        this.oaCtx.update((Table)WD).set((Field)OAWorkAddressRepository.WD.TIMEKEEPER, (Object)newKeeper).where(new Condition[]{OAWorkAddressRepository.WD.TIMEKEEPER.eq((Object)currentlyKeeper)}).execute();
    }

    public boolean isTimekeeper(String uid, String workAddrId) {
        return this.oaCtx.fetchExists((Table)WD, OAWorkAddressRepository.WD.ID.eq((Object)workAddrId).and(OAWorkAddressRepository.WD.TIMEKEEPER.eq((Object)uid)));
    }

    public List<String> findWorkAddressIdForKeeper(String uid) {
        return this.oaCtx.select((SelectField)OAWorkAddressRepository.WD.ID).from((TableLike)WD).where(new Condition[]{OAWorkAddressRepository.WD.TIMEKEEPER.eq((Object)uid)}).fetchInto(String.class);
    }

    public List<com.jz.jooq.oa.tables.pojos.WorkAddress> getAllWorkAddressSimple() {
        return this.oaCtx.select((SelectField)OAWorkAddressRepository.WD.ID, (SelectField)OAWorkAddressRepository.WD.NAME).from((TableLike)WD).fetchInto(com.jz.jooq.oa.tables.pojos.WorkAddress.class);
    }

    public List<String> getAllAddressIds() {
        return this.oaCtx.select((SelectField)OAWorkAddressRepository.WD.ID).from((TableLike)WD).fetchInto(String.class);
    }
}

