package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.oa.repository.OAWorkAddressRepository;
import com.jz.jooq.oa.tables.pojos.WorkAddress;

@Lazy
@Service
public class OAWorkAddressService {

	@Autowired
	private OAWorkAddressRepository workAddressRepository;

	public List<WorkAddress> getAllWorkAddress() {
		return workAddressRepository.getAllWorkAddress();
	}

	public List<WorkAddress> getAllWorkAddressSimple() {
		return workAddressRepository.getAllWorkAddressSimple();
	}

	public Map<String, WorkAddress> mutiGetWorkAddressMap(Collection<String> workAddrIds) {
		List<WorkAddress> list = workAddressRepository.mutiWorkAddress(workAddrIds);
		return list.stream().collect(Collectors.toMap(it -> it.getId(), it -> it));
	}

	public WorkAddress getWorkAddress(String workAddrId) {
		return workAddressRepository.getWorkAddress(workAddrId);
	}

	public boolean checkName(String name) {
		return workAddressRepository.checkName(name);
	}

	public void updateTimekeeper(String currentlyKeeper, String newKeeper) {
		workAddressRepository.updateTimekeeper(currentlyKeeper, newKeeper);
	}

	public boolean isTimekeeper(String uid, String workAddrId) {
		return workAddressRepository.isTimekeeper(uid, workAddrId);
	}

	public List<String> findWorkAddressIdForKeeper(String uid) {
		return workAddressRepository.findWorkAddressIdForKeeper(uid);
	}
	
	public List<String> getAllAddressIds() {
		return workAddressRepository.getAllAddressIds();
	}
}
