package com.jz.jar.oa.repository;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserVacationUsed;
import com.jz.jooq.oa.tables.records.UserVacationUsedRecord;

@Lazy
@Repository
public class UserVacationUsedRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserVacationUsed V = Tables.USER_VACATION_USED;

	public List<UserVacationUsed> getUserVacationUsed(List<String> filterUids) {
		return oaCtx.selectFrom(V).where(V.UID.in(filterUids)).fetchInto(UserVacationUsed.class);
	}

	public UserVacationUsed getUserVacationUsed(String uid) {
		return oaCtx.selectFrom(V).where(V.UID.eq(uid)).fetchAnyInto(UserVacationUsed.class);
	}

	public void addVacationUsed(String uid, Map<String, Double> type2day) {
		List<UserVacationUsedRecord> records = Lists.newArrayList();
		for (Map.Entry<String, Double> entry : type2day.entrySet()) {
			UserVacationUsedRecord record = new UserVacationUsedRecord();
			record.setUid(uid);
			record.setType(entry.getKey());
			record.setNum(new BigDecimal(entry.getValue()));
			record.setLastUpdated(System.currentTimeMillis());
			records.add(record);
		}
		oaCtx.batchInsert(records).execute();
	}

	public Map<String, Double> getUsedVacation(String uid) {
		List<Map<String, Object>> list = oaCtx.select(V.TYPE.as("type"), V.NUM.as("num")).from(V).where(V.UID.eq(uid))
				.groupBy(V.TYPE).fetchMaps();
		Map<String, Double> map = Maps.newHashMap();
		list.forEach(it -> {
			map.put(MapUtils.getString(it, "type"), MapUtils.getDouble(it, "num"));
		});
		return map;
	}

	public void cleanVacationUsed(String uid) {
		oaCtx.deleteFrom(V).where(V.UID.eq(uid)).execute();
	}

	public void subtractVacationUsed(String uid, String leaveType, double leaveDay) {
		oaCtx.update(V).set(V.NUM, V.NUM.sub(leaveDay)).set(V.LAST_UPDATED, System.currentTimeMillis())
				.where(V.UID.eq(uid).and(V.TYPE.eq(leaveType))).execute();
	}

}
