package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.Company;
import com.jz.jooq.oa.tables.records.CompanyRecord;

@Lazy
@Repository
public class OACompanyRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.Company C = Tables.COMPANY;

	public List<Company> getAllCompany() {
		return oaCtx.selectFrom(C).fetchInto(Company.class);
	}

	public List<Company> multiGetCompanies(Collection<String> companyIds) {
		return oaCtx.selectFrom(C).where(C.ID.in(companyIds)).orderBy(C.ID.sortAsc(companyIds))
				.fetchInto(Company.class);
	}

	public List<Company> mutiGetCompanys(Collection<String> companyIds) {
		return oaCtx.selectFrom(C).where(C.ID.in(companyIds)).fetchInto(Company.class);
	}

	public List<Company> multiGetSimpleCompanies(Collection<String> companyIds) {
		return oaCtx.select(C.ID, C.NAME).from(C).where(C.ID.in(companyIds)).fetchInto(Company.class);
	}

	public Company getCompany(String companyId) {
		return oaCtx.selectFrom(C).where(C.ID.eq(companyId)).fetchAnyInto(Company.class);
	}

	public boolean checkName(String name) {
		return oaCtx.fetchExists(C, C.NAME.eq(name));
	}

	public void createCompany(String id, String name, String license, String accounter, String cashier,
			String assetsKeeperIT, String assetsKeeperWork, String law) {
		oaCtx.insertInto(C).set(new CompanyRecord(id, name, license, accounter, cashier, assetsKeeperIT,
				assetsKeeperWork, law, System.currentTimeMillis())).execute();
	}

	public boolean checkExist(String companyId) {
		return oaCtx.fetchExists(C, C.ID.eq(companyId));
	}

	public void updateCompany(String id, String name, String license, String accounter, String cashier,
			String assetsKeeperIT, String assetsKeeperWork, String law) {
		CompanyRecord record = new CompanyRecord();
		record.setName(name);
		record.setLicense(license);
		record.setAccounter(accounter);
		record.setCashier(cashier);
		record.setAssetsKeeperIt(assetsKeeperIT);
		record.setAssetsKeeperWork(assetsKeeperWork);
		record.setLaw(law);
		oaCtx.update(C).set(record).where(C.ID.eq(id)).execute();
	}

	public void deleteCompany(String id) {
		oaCtx.deleteFrom(C).where(C.ID.eq(id)).execute();
	}

	public List<Company> getCompanyForAssetsManager(String assetsKeeper) {
		return oaCtx.select(C.ID, C.NAME).from(C)
				.where(C.ASSETS_KEEPER_IT.eq(assetsKeeper).or(C.ASSETS_KEEPER_WORK.eq(assetsKeeper)))
				.fetchInto(Company.class);
	}

	public boolean isAssetManager(String companyId, String uid, boolean isIt) {
		Condition condition = isIt ? C.ASSETS_KEEPER_IT.eq(uid) : C.ASSETS_KEEPER_WORK.eq(uid);
		return oaCtx.fetchExists(C, C.ID.eq(companyId).and(condition));
	}

	public void updateAssetsKeeper(String currentlyKeeper, String newKeeper) {
		oaCtx.update(C).set(C.ASSETS_KEEPER_IT, newKeeper).where(C.ASSETS_KEEPER_IT.eq(currentlyKeeper)).execute();
	}

	public void updateAccounter(String currentlyAccounter, String newAccounter) {
		oaCtx.update(C).set(C.ACCOUNTER, newAccounter).where(C.ACCOUNTER.eq(currentlyAccounter)).execute();
	}

	public void updateCashier(String currentlyCashier, String newCashier) {
		oaCtx.update(C).set(C.CASHIER, newCashier).where(C.CASHIER.eq(currentlyCashier)).execute();
	}

	public void updateLaw(String currentlyLaw, String newLaw) {
		oaCtx.update(C).set(C.LAW, newLaw).where(C.LAW.eq(currentlyLaw)).execute();
	}

	public List<Company> getAllCompanySimple() {
		return oaCtx.select(C.ID, C.NAME, C.ASSETS_KEEPER_IT, C.ASSETS_KEEPER_WORK).from(C).fetchInto(Company.class);
	}
}
