package com.jz.jar.oa.wrapper;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jz.common.utils.text.StringTools;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.pojos.UserWorkflowHandler;
import com.jz.jooq.oa.tables.pojos.UserWorkflowHandlerAttachment;
import com.jz.jooq.oa.tables.pojos.WorkflowSetting;

public class WorkflowHandler {

	private String uid;
	private String name;
	private String handleName;
	private Integer step;
	// 是否需要添加职称
	private Boolean isAddPosition;
	// 是否抄送
	private Boolean isCarbonCopy;

	// 处理人信息
	private String positionName;
	private Boolean isPassed;
	private String remarks;
	private Boolean isAddSignature;
	private String addSignatureReason;
	private Long auditTime;
	// 处理人附件
	private List<UserWorkflowHandlerAttachment> attachments;
	// 处理人扩展信息
	private String extType;
	private Object extData;

	public static WorkflowHandler of(String uid, WorkflowSetting workflow) {
		return of(uid, workflow, false);
	}

	public static WorkflowHandler of(String uid, WorkflowSetting workflow, boolean isAddPosition) {
		WorkflowHandler handler = new WorkflowHandler().setUid(uid).setIsAddPosition(isAddPosition)
				.setIsCarbonCopy(workflow.getCarbonCopy() > 0);
		if (workflow.getCarbonCopy() > 0)
			return handler;
		handler.setHandleName(workflow.getHandleName());
		if (workflow.getIsExt() > 0)
			handler.setExtType(workflow.getType());
		return handler;
	}

	public static WorkflowHandler of(User user, UserWorkflowHandler handler) {
		WorkflowHandler result = new WorkflowHandler().setUid(user.getUid()).setName(user.getChineseName())
				.setHandleName(handler.getHandleName()).setStep(handler.getStep())
				.setPositionName(handler.getPositionName()).setExtType(handler.getExtType());
		// 已审核
		if (null != handler.getResult())
			result.setIsPassed(handler.getResult() == 1).setRemarks(handler.getRemarks())
					.setAuditTime(handler.getLastUpdate());
		// 加签
		if (StringTools.isNotEmptyAndBlank(handler.getReason())) {
			result.setIsAddSignature(true).setAddSignatureReason(handler.getReason());
		}
		return result;
	}

	public String getUid() {
		return uid;
	}

	public WorkflowHandler setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getName() {
		return name;
	}

	public WorkflowHandler setName(String name) {
		this.name = name;
		return this;
	}

	public String getHandleName() {
		return handleName;
	}

	public WorkflowHandler setHandleName(String handleName) {
		this.handleName = handleName;
		return this;
	}

	public Integer getStep() {
		return step;
	}

	public WorkflowHandler setStep(Integer step) {
		this.step = step;
		return this;
	}

	@JsonIgnore
	public Boolean getIsAddPosition() {
		return isAddPosition;
	}

	public WorkflowHandler setIsAddPosition(Boolean isAddPosition) {
		this.isAddPosition = isAddPosition;
		return this;
	}

	public Boolean getIsCarbonCopy() {
		return isCarbonCopy;
	}

	public WorkflowHandler setIsCarbonCopy(Boolean isCarbonCopy) {
		this.isCarbonCopy = isCarbonCopy;
		return this;
	}

	public String getPositionName() {
		return positionName;
	}

	public WorkflowHandler setPositionName(String positionName) {
		this.positionName = positionName;
		return this;
	}

	public Boolean getIsPassed() {
		return isPassed;
	}

	public WorkflowHandler setIsPassed(Boolean isPassed) {
		this.isPassed = isPassed;
		return this;
	}

	public String getRemarks() {
		return remarks;
	}

	public WorkflowHandler setRemarks(String remarks) {
		this.remarks = remarks;
		return this;
	}

	public Boolean getIsAddSignature() {
		return isAddSignature;
	}

	public WorkflowHandler setIsAddSignature(Boolean isAddSignature) {
		this.isAddSignature = isAddSignature;
		return this;
	}

	public String getAddSignatureReason() {
		return addSignatureReason;
	}

	public WorkflowHandler setAddSignatureReason(String addSignatureReason) {
		this.addSignatureReason = addSignatureReason;
		return this;
	}

	public Long getAuditTime() {
		return auditTime;
	}

	public WorkflowHandler setAuditTime(Long auditTime) {
		this.auditTime = auditTime;
		return this;
	}

	public List<UserWorkflowHandlerAttachment> getAttachments() {
		return attachments;
	}

	public WorkflowHandler setAttachments(List<UserWorkflowHandlerAttachment> attachments) {
		this.attachments = attachments;
		return this;
	}

	public String getExtType() {
		return extType;
	}

	public WorkflowHandler setExtType(String extType) {
		this.extType = extType;
		return this;
	}

	public Object getExtData() {
		return extData;
	}

	public WorkflowHandler setExtData(Object extData) {
		this.extData = extData;
		return this;
	}

}
