/*
 * Decompiled with CFR 0.152.
 */
package com.jz.web.mvc.common.filters;

import com.jz.common.utils.text.StringTools;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletAccessFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(HttpServletAccessFilter.class);
    private static String characterEncoding = "UTF-8";
    private static boolean showSwagger = false;
    private static boolean showRequestUrl = true;

    public HttpServletAccessFilter() {
    }

    public HttpServletAccessFilter(boolean showSwagger, boolean showRequestUrl) {
        HttpServletAccessFilter.showSwagger = showSwagger;
        HttpServletAccessFilter.showRequestUrl = showRequestUrl;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setCharacterEncoding(characterEncoding);
        response.setCharacterEncoding(characterEncoding);
        HttpServletRequest http = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (http.getRequestURI().lastIndexOf("/swagger-ui.html") > 0 && !showSwagger) {
            httpResponse.getWriter().write("{\"status\":404, \"msg\":\"not found\"}");
            return;
        }
        long startTimestamp = System.currentTimeMillis();
        StringBuffer sb = null;
        if (showRequestUrl) {
            sb = new StringBuffer(http.getMethod()).append(" ");
            sb.append(http.getRequestURI()).append("?");
            Enumeration names = request.getParameterNames();
            String element = null;
            while (names.hasMoreElements()) {
                element = (String)names.nextElement();
                if (StringTools.contains((String[])new String[]{element, "password", "pwd"})) {
                    sb.append(element).append("=******&");
                    continue;
                }
                sb.append(element).append("=").append(request.getParameter(element)).append("&");
            }
            sb.delete(sb.length() - 1, sb.length()).append(" - ");
        }
        chain.doFilter((ServletRequest)http, response);
        if (showRequestUrl) {
            sb.append(httpResponse.getContentType()).append(" ");
            sb.append(httpResponse.getStatus()).append(" - ");
            long timestamp = System.currentTimeMillis() - startTimestamp;
            sb.append("Timer : ").append(timestamp).append("ms");
            logger.info(sb.toString());
            if (timestamp > 3000L) {
                logger.warn(sb.toString());
            }
        }
    }

    public void destroy() {
    }
}

