package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.PlaylistTagsRepository;
import com.jz.jooq.media.tables.pojos.PlaylistTags;

@Lazy
@Service
public class PlaylistTagsService {

	@Autowired
	private PlaylistTagsRepository playlistTagsRepository;

	public List<String> getTagsForPlaylist(String pid) {
		return playlistTagsRepository.getTagsForPlaylist(pid);
	}

	public List<String> findTagsForPlaylistIds(List<String> pids) {
		return playlistTagsRepository.findTagsForPlaylistIds(pids);
	}

	public int countPlaylistForPlaylistAndTag(List<String> pids, String tid) {
		return playlistTagsRepository.countPlaylistForPlaylistAndTag(pids, tid);
	}

	public List<String> findPlaylistForPlaylistAndTag(List<String> pids, String tid, int start, int size) {
		return playlistTagsRepository.findPlaylistForPlaylistAndTag(pids, tid, start, size);
	}

	public List<PlaylistTags> findPlaylistTagInfoForTags(Collection<String> tids) {
		return playlistTagsRepository.findPlaylistTagInfoForTags(tids);
	}
}
