package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.cache.MediaVideoCache;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.MediaVideoRepository;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.records.MediaVideoRecord;

@Lazy
@Service
public class MediaVideoService {

	@Autowired
	private MediaVideoRepository mediaVideoRepository;
	@Autowired
	private MediaVideoCache mediaVideoCache;

	public MediaVideo getVideo(String wid, BrandEnum brand) {
		MediaVideo video = mediaVideoCache.getMediaVideo(wid, brand);
		if (null != video)
			return video;
		video = mediaVideoRepository.getVideo(wid, brand);
		if (null == video)
			return null;
		mediaVideoCache.setMediaVideo(video, brand);
		return video;
	}

	public List<MediaVideo> findVideos(Collection<String> wids) {
		return mediaVideoRepository.findVideos(wids);
	}

	public void saveOrUpdateVideo(MediaVideoRecord mediaVideoRecord) {
		mediaVideoRepository.saveOrUpdateVideo(mediaVideoRecord);
	}
	
	public boolean isExist(String wid, BrandEnum brand) {
		return mediaVideoRepository.isExist(wid, brand);
	}
	
	public void addWatchCnt(String wid, BrandEnum brand, int cnt) {
		mediaVideoRepository.addWatchCnt(wid, brand, cnt); // 这块延迟没问题
	}
}
