/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.UserCollect;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserCollectRepository
extends MediaBaseRepository {
    private static final UserCollect UC = Tables.USER_COLLECT;

    public void addCollect(String uid, String pid) {
        this.mediaCtx.insertInto((Table)UC, (Field)UserCollectRepository.UC.UID, (Field)UserCollectRepository.UC.PID, (Field)UserCollectRepository.UC.CREATE_TIME).values((Object)uid, (Object)pid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public List<com.jz.jooq.media.tables.pojos.UserCollect> getCollect(String uid) {
        return this.mediaCtx.selectFrom((Table)UC).where(new Condition[]{UserCollectRepository.UC.UID.eq((Object)uid)}).orderBy(UserCollectRepository.UC.CREATE_TIME.desc()).fetchInto(com.jz.jooq.media.tables.pojos.UserCollect.class);
    }

    public int countCollect(String uid) {
        return this.mediaCtx.fetchCount((Table)UC, UserCollectRepository.UC.UID.eq((Object)uid));
    }

    public List<com.jz.jooq.media.tables.pojos.UserCollect> getCollect(String uid, int start, int size) {
        return this.mediaCtx.selectFrom((Table)UC).where(new Condition[]{UserCollectRepository.UC.UID.eq((Object)uid)}).orderBy(UserCollectRepository.UC.CREATE_TIME.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.UserCollect.class);
    }

    public boolean isCollect(String uid, String pid) {
        return this.mediaCtx.fetchExists((Table)UC, UserCollectRepository.UC.UID.eq((Object)uid).and(UserCollectRepository.UC.PID.eq((Object)pid)));
    }

    public void deleteCollect(String uid, String pid) {
        this.mediaCtx.deleteFrom((Table)UC).where(new Condition[]{UserCollectRepository.UC.UID.eq((Object)uid).and(UserCollectRepository.UC.PID.eq((Object)pid))}).execute();
    }

    public List<String> getExistCollect(String uid, Collection<String> pids) {
        return this.mediaCtx.select((SelectField)UserCollectRepository.UC.PID).from((TableLike)UC).where(new Condition[]{UserCollectRepository.UC.UID.eq((Object)uid).and(UserCollectRepository.UC.PID.in(pids))}).fetchInto(String.class);
    }
}

