package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.CtxType;
import com.jz.jar.media.repository.CommentInfoRepository;
import com.jz.jooq.media.tables.pojos.CommentInfo;

@Lazy
@Service
public class CommentInfoService {

	@Autowired
	private CommentInfoRepository commentInfoRepository;

	public void addComment(BrandEnum brand, String id, CtxType type, String sourceId, String uid, String content,
			String replyId) {
		commentInfoRepository.addComment(brand, id, type, sourceId, uid, content, replyId);
	}

	public int countCommentInfo(BrandEnum brand, CtxType type, String sourceId) {
		return commentInfoRepository.countCommentInfo(brand, type, sourceId);
	}

	public List<CommentInfo> getCommentInfo(BrandEnum brand, CtxType type, String sourceId, int start, int size) {
		return commentInfoRepository.getCommentInfo(brand, type, sourceId, start, size);
	}

	public CommentInfo getCommentInfo(BrandEnum brand, String id) {
		return commentInfoRepository.getCommentInfo(brand, id);
	}

	public List<CommentInfo> getCommentUids(Collection<String> ids) {
		return commentInfoRepository.getCommentUids(ids);
	}
}
