package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TestsRepository;
import com.jz.jooq.media.tables.pojos.TestsMultipleOptionScore;
import com.jz.jooq.media.tables.pojos.TestsOption;
import com.jz.jooq.media.tables.pojos.TestsPluses;
import com.jz.jooq.media.tables.pojos.TestsQuestion;

@Lazy
@Service
public class TestsService {

	@Autowired
	private TestsRepository testsRepository;

	public List<TestsQuestion> getOnlineQuestion() {
		return testsRepository.getOnlineQuestion();
	}

	public List<TestsOption> getOptions(Collection<String> questionIds) {
		return testsRepository.getOptions(questionIds);
	}

	public List<TestsPluses> getPluses(Collection<String> questionIds, int age) {
		return testsRepository.getPluses(questionIds, age);
	}

	public List<TestsMultipleOptionScore> getMultipleScore(Collection<String> questionIds) {
		return testsRepository.getMultipleScore(questionIds);
	}

	public void refreshScore(String uid, String suid, String crowd,
			List<Triple<String, Integer, String>> direction2Score2Content) {
		testsRepository.refreshScore(uid, suid, crowd, direction2Score2Content);
	}
}
