/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Lists;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.StudentTestsMultipleScore;
import com.jz.jooq.media.tables.StudentTestsPluses;
import com.jz.jooq.media.tables.pojos.StudentTestsOptions;
import com.jz.jooq.media.tables.pojos.StudentTestsQuestion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.jooq.Condition;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class StudentTestsRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.StudentTestsQuestion QUESTION = Tables.STUDENT_TESTS_QUESTION;
    private static final com.jz.jooq.media.tables.StudentTestsOptions OPTION = Tables.STUDENT_TESTS_OPTIONS;
    private static final StudentTestsPluses PLUS = Tables.STUDENT_TESTS_PLUSES;
    private static final StudentTestsMultipleScore MULTIPLE = Tables.STUDENT_TESTS_MULTIPLE_SCORE;

    public List<StudentTestsQuestion> getOnlineQuestion() {
        return this.mediaCtx.selectFrom((Table)QUESTION).where(new Condition[]{StudentTestsRepository.QUESTION.STATUS.eq((Object)SourceStatus.online.getCode())}).orderBy(StudentTestsRepository.QUESTION.SEQ.asc()).fetchInto(StudentTestsQuestion.class);
    }

    public List<StudentTestsOptions> getOptions(Collection<String> questionIds) {
        return this.mediaCtx.selectFrom((Table)OPTION).where(new Condition[]{StudentTestsRepository.OPTION.QID.in(questionIds)}).orderBy(StudentTestsRepository.OPTION.SEQ.asc()).fetchInto(StudentTestsOptions.class);
    }

    public List<com.jz.jooq.media.tables.pojos.StudentTestsPluses> getPluses(Collection<String> questionIds, int age) {
        return this.mediaCtx.selectFrom((Table)PLUS).where(new Condition[]{StudentTestsRepository.PLUS.QID.in(questionIds).and(StudentTestsRepository.PLUS.MAX_AGE.ge((Object)age)).and(StudentTestsRepository.PLUS.MIN_AGE.le((Object)age))}).fetchInto(com.jz.jooq.media.tables.pojos.StudentTestsPluses.class);
    }

    public List<com.jz.jooq.media.tables.pojos.StudentTestsMultipleScore> getMultipleScore(Collection<String> questionIds) {
        return this.mediaCtx.selectFrom((Table)MULTIPLE).where(new Condition[]{StudentTestsRepository.MULTIPLE.QID.in(questionIds)}).fetchInto(com.jz.jooq.media.tables.pojos.StudentTestsMultipleScore.class);
    }

    public void refreshStudentScore(String suid, List<Triple<String, Integer, String>> direction2Score2Content) {
        long timeMillis = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO `student_tests_scores` ");
        sb.append("(`suid` ,`direction` ,`score` ,`content` ,`create_time` )");
        sb.append("VALUES (?, ?, ?, ?, ?)");
        sb.append("ON DUPLICATE KEY UPDATE `score` = ?, `content` = ?, `create_time` = ?");
        ArrayList batchArgs = Lists.newArrayList();
        for (Triple<String, Integer, String> triple : direction2Score2Content) {
            batchArgs.add(new Object[]{suid, triple.getLeft(), triple.getMiddle(), triple.getRight(), timeMillis, triple.getMiddle(), triple.getRight(), timeMillis});
        }
        this.mediaJdbcTemplate.batchUpdate(sb.toString(), (List)batchArgs);
    }
}

