package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.DayPlaySetting;

@Lazy
@Repository
public class DayPlaySettingRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.DayPlaySetting DPS = Tables.DAY_PLAY_SETTING;

	public List<DayPlaySetting> getTodayTaskPlaylist(String today, String lid) {
		return mediaCtx.select(DPS.PID, DPS.CID).from(DPS).where(DPS.DAY.eq(today).and(DPS.LID.eq(lid))).fetchInto(DayPlaySetting.class);
	}

	public boolean isTodayTaskPlaylist(String today, String lid, String pid) {
		return mediaCtx.fetchExists(DPS, DPS.DAY.eq(today).and(DPS.LID.eq(lid)).and(DPS.PID.eq(pid)));
	}

	public Map<String, Integer> getEverdayPlaylistCount(Collection<String> days, String lid) {
		Result<Record2<String, Integer>> result = mediaCtx.select(DPS.DAY, DSL.count(DPS.DAY)).from(DPS)
				.where(DPS.DAY.in(days).and(DPS.LID.eq(lid))).groupBy(DPS.DAY).fetch();
		if (null == result || result.isEmpty())
			return Maps.newHashMap();
		Map<String, Integer> has = Maps.newHashMap();
		result.forEach(it -> has.put(it.value1(), it.value2()));
		return has;
	}
}
