/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.PlaylistTags;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class PlaylistTagsRepository
extends MediaBaseRepository {
    private static final PlaylistTags PT = Tables.PLAYLIST_TAGS;

    public List<String> getTagsForPlaylist(String pid) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistTagsRepository.PT.TID).from((TableLike)PT).where(new Condition[]{PlaylistTagsRepository.PT.PID.eq((Object)pid)}).fetchInto(String.class);
    }

    public List<String> findTagsForPlaylistIds(List<String> pids) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistTagsRepository.PT.TID).from((TableLike)PT).where(new Condition[]{PlaylistTagsRepository.PT.PID.in(pids)}).fetchInto(String.class);
    }

    public int countPlaylistForPlaylistAndTag(List<String> pids, String tid) {
        return this.mediaCtx.fetchCount((Table)PT, PlaylistTagsRepository.PT.PID.in(pids).and(PlaylistTagsRepository.PT.TID.eq((Object)tid)));
    }

    public List<String> findPlaylistForPlaylistAndTag(List<String> pids, String tid, int start, int size) {
        return this.mediaCtx.select((SelectField)PlaylistTagsRepository.PT.PID).from((TableLike)PT).where(new Condition[]{PlaylistTagsRepository.PT.PID.in(pids).and(PlaylistTagsRepository.PT.TID.eq((Object)tid))}).orderBy(PlaylistTagsRepository.PT.SEQ.asc()).limit(start, size).fetchInto(String.class);
    }
}

