package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.common.utils.json.GsonTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class StudentPlayMonthTotalRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.StudentPlayMonthTotal MONTH = Tables.STUDENT_PLAY_MONTH_TOTAL;
	private static final com.jz.jooq.media.tables.StudentPlayMonthTagTotal TAG = Tables.STUDENT_PLAY_MONTH_TAG_TOTAL;

	public void refreshPlayTotal(BrandEnum brand, String suid, String month, int playLength, int videoCnt) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(MONTH, MONTH.BRAND, MONTH.SUID, MONTH.MONTH, MONTH.PLAY_TIME, MONTH.VIDEO_CNT,
				MONTH.CREATE_TIME, MONTH.LAST_UPDATE)
				.values(brand.name(), suid, month, playLength, videoCnt, timeMillis, timeMillis).onDuplicateKeyUpdate()
				.set(MONTH.PLAY_TIME, MONTH.PLAY_TIME.add(playLength))
				.set(MONTH.VIDEO_CNT, MONTH.VIDEO_CNT.add(videoCnt)).set(MONTH.LAST_UPDATE, timeMillis).execute();
	}

	public void refreshTagPlayTotal(BrandEnum brand, String suid, String month, List<String> tags, int playLength,
			int videoCnt) {
		long timeMillis = System.currentTimeMillis();
		List<String> sqls = Lists.newArrayList();
		for (String tag : tags) {
			sqls.add(mediaCtx
					.insertInto(TAG, TAG.BRAND, TAG.SUID, TAG.TAG, TAG.MONTH, TAG.PLAY_TIME, TAG.VIDEO_CNT,
							TAG.CREATE_TIME, TAG.LAST_UPDATE)
					.values(brand.name(), suid, tag, month, playLength, videoCnt, timeMillis, timeMillis)
					.onDuplicateKeyUpdate().set(MONTH.PLAY_TIME, MONTH.PLAY_TIME.add(playLength))
					.set(MONTH.VIDEO_CNT, MONTH.VIDEO_CNT.add(videoCnt)).set(MONTH.LAST_UPDATE, timeMillis).getSQL());
		}
		String[] array = {};
		System.out.println("sqls : " + GsonTools.gson.toJson(sqls));
		mediaCtx.batch(sqls.toArray(array));
	}
}
