package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.WorksInfoRepository;

@Lazy
@Service
public class WorksThemeRelationService {

	@Autowired
	private WorksInfoRepository worksInfoRepository;

	public int countWorks(BrandEnum brand, String themeId) {
		return worksInfoRepository.countWorks(brand, themeId);
	}

	public List<String> getWorkIds(BrandEnum brand, String themeId, boolean isHot, int start, int size) {
		return worksInfoRepository.getWorkIds(brand, themeId, isHot, start, size);
	}

	public List<String> getAllThemeIds(String artId) {
		return worksInfoRepository.getAllThemeIds(artId);
	}

	public void addLikeCnt(String artId, int cnt) {
		worksInfoRepository.addLikeCnt(artId, cnt);
	}
}
