package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserCollectRepository;
import com.jz.jooq.media.tables.pojos.UserCollect;

@Lazy
@Service
public class UserCollectService {

	@Autowired
	private UserCollectRepository userCollectRepository;

	public void addCollect(String uid, String pid) {
		userCollectRepository.addCollect(uid, pid);
	}

	public List<UserCollect> getCollect(String uid) {
		return userCollectRepository.getCollect(uid);
	}

	public int countCollect(String uid) {
		return userCollectRepository.countCollect(uid);
	}

	public List<UserCollect> getCollect(String uid, int start, int size) {
		return userCollectRepository.getCollect(uid, start, size);
	}

	public boolean isCollect(String uid, String pid) {
		return userCollectRepository.isCollect(uid, pid);
	}

	public void deleteCollect(String uid, String pid) {
		userCollectRepository.deleteCollect(uid, pid);
	}

	public List<String> getExistCollect(String uid, Collection<String> pids) {
		return userCollectRepository.getExistCollect(uid, pids);
	}
}
