/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.WorksLike;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class WorksLikeRepository
extends MediaBaseRepository {
    private static final WorksLike WL = Tables.WORKS_LIKE;

    public int countForWorkId(String id) {
        return this.mediaCtx.fetchCount((Table)WL, WorksLikeRepository.WL.WORK_ID.eq((Object)id));
    }

    public int countForWorkId(Collection<String> ids) {
        return this.mediaCtx.fetchCount((Table)WL, WorksLikeRepository.WL.WORK_ID.in(ids));
    }

    public Map<String, Integer> getLikeCount(Collection<String> workIds) {
        List rows = this.mediaCtx.select((SelectField)WorksLikeRepository.WL.WORK_ID, (SelectField)DSL.count((Field)WorksLikeRepository.WL.PUID).as("ct")).from((TableLike)WL).where(new Condition[]{WorksLikeRepository.WL.WORK_ID.in(workIds)}).groupBy(new GroupField[]{WorksLikeRepository.WL.WORK_ID}).fetchMaps();
        if (ArrayMapTools.isEmpty((Collection)rows)) {
            return Maps.newHashMap();
        }
        HashMap workId2Cnt = Maps.newHashMap();
        for (Map has : rows) {
            if (!ArrayMapTools.containsKeys((Map)has, (String[])new String[]{"art_id", "ct"})) continue;
            workId2Cnt.put(MapUtils.getString((Map)has, (Object)"art_id"), MapUtils.getInteger((Map)has, (Object)"ct"));
        }
        return workId2Cnt;
    }

    public boolean existForIdAndUid(String id, String puid) {
        return this.mediaCtx.fetchExists((Table)WL, WorksLikeRepository.WL.WORK_ID.eq((Object)id).and(WorksLikeRepository.WL.PUID.eq((Object)puid)));
    }

    public List<String> screenLike(Collection<String> workIds, String puid) {
        return this.mediaCtx.select((SelectField)WorksLikeRepository.WL.WORK_ID).from((TableLike)WL).where(new Condition[]{WorksLikeRepository.WL.WORK_ID.in(workIds).and(WorksLikeRepository.WL.PUID.eq((Object)puid))}).fetchInto(String.class);
    }

    public void addWorkLike(String workId, String puid) {
        this.mediaCtx.insertInto((Table)WL, (Field)WorksLikeRepository.WL.WORK_ID, (Field)WorksLikeRepository.WL.PUID, (Field)WorksLikeRepository.WL.CREATE_TIME).values((Object)workId, (Object)puid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void deleteWorkLike(String workId) {
        this.mediaCtx.deleteFrom((Table)WL).where(new Condition[]{WorksLikeRepository.WL.WORK_ID.eq((Object)workId)}).execute();
    }

    public void deleteWorkLike(String workId, String puid) {
        this.mediaCtx.deleteFrom((Table)WL).where(new Condition[]{WorksLikeRepository.WL.WORK_ID.eq((Object)workId).and(WorksLikeRepository.WL.PUID.eq((Object)puid))}).execute();
    }

    public int countMyLike(String puid) {
        return this.mediaCtx.fetchCount((Table)WL, WorksLikeRepository.WL.PUID.eq((Object)puid));
    }

    public List<String> getMyLike(String puid, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksLikeRepository.WL.WORK_ID).from((TableLike)WL).where(new Condition[]{WorksLikeRepository.WL.PUID.eq((Object)puid)}).orderBy(WorksLikeRepository.WL.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }
}

