/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.google.common.collect.Lists;
import com.jz.jar.media.repository.ArtLikeRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ArtLikeService {
    @Autowired
    private ArtLikeRepository artLikeRepository;

    public int countForArtId(String id) {
        return this.artLikeRepository.countForArtId(id);
    }

    public int countForArtId(Collection<String> ids) {
        return this.artLikeRepository.countForArtId(ids);
    }

    public boolean existForIdAndUid(String id, String puid) {
        return this.artLikeRepository.existForIdAndUid(id, puid);
    }

    public Map<String, Integer> getLikeCount(Collection<String> artIds) {
        return this.artLikeRepository.getLikeCount(artIds);
    }

    public List<String> screenLike(Collection<String> artIds, String puid) {
        List<String> likes = this.artLikeRepository.screenLike(artIds, puid);
        return null == likes ? Lists.newArrayList() : likes;
    }

    public void addArtLike(String artId, String puid) {
        this.artLikeRepository.addArtLike(artId, puid);
    }

    public void deleteArtLike(String artId) {
        this.artLikeRepository.deleteArtLike(artId);
    }

    public void deleteArtLike(String artId, String puid) {
        this.artLikeRepository.deleteArtLike(artId, puid);
    }

    public int countMyLike(String puid) {
        return this.artLikeRepository.countMyLike(puid);
    }

    public List<String> getMyLike(String puid, int start, int size) {
        return this.artLikeRepository.getMyLike(puid, start, size);
    }
}

