package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.jar.media.repository.ArtLikeRepository;

@Lazy
@Service
public class ArtLikeService {

	@Autowired
	private ArtLikeRepository artLikeRepository;

	public int countForArtId(String id) {
		return artLikeRepository.countForArtId(id);
	}
	
	public int countForArtId(Collection<String> ids) {
		return artLikeRepository.countForArtId(ids);
	}
	
	public boolean existForIdAndUid(String id, String puid) {
		return artLikeRepository.existForIdAndUid(id, puid);
	}

	public Map<String, Integer> getLikeCount(Collection<String> artIds) {
		return artLikeRepository.getLikeCount(artIds);
	}

	public List<String> screenLike(Collection<String> artIds, String puid) {
		List<String> likes = artLikeRepository.screenLike(artIds, puid);
		return null == likes ? Lists.newArrayList() : likes;
	}

	public void addArtLike(String artId, String puid) {
		artLikeRepository.addArtLike(artId, puid);
	}
	
	public void deleteArtLike(String artId) {
		artLikeRepository.deleteArtLike(artId);
	}
	
	public void deleteArtLike(String artId, String puid) {
		artLikeRepository.deleteArtLike(artId, puid);
	}

	public int countMyLike(String puid) {
		return artLikeRepository.countMyLike(puid);
	}

	public List<String> getMyLike(String puid, int start, int size) {
		return artLikeRepository.getMyLike(puid, start, size);
	}
}
