package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.records.MediaVideoRecord;

@Lazy
@Repository
public class MediaVideoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.MediaVideo VIDEO = Tables.MEDIA_VIDEO;

	public MediaVideo getVideo(String wid, BrandEnum brand) {
		return mediaCtx.selectFrom(VIDEO).where(VIDEO.WID.eq(wid).and(VIDEO.BRAND.eq(brand.name())))
				.fetchAnyInto(MediaVideo.class);
	}

	public List<MediaVideo> findVideos(Collection<String> wids) {
		return mediaCtx.selectFrom(VIDEO).where(VIDEO.WID.in(wids)).fetchInto(MediaVideo.class);
	}

	public void saveOrUpdateVideo(MediaVideoRecord mediaVideoRecord) {
		mediaCtx.insertInto(VIDEO).set(mediaVideoRecord).onDuplicateKeyUpdate().set(mediaVideoRecord).execute();
	}

	public boolean isExist(String wid, BrandEnum brand) {
		return mediaCtx.fetchExists(VIDEO, VIDEO.WID.eq(wid).and(VIDEO.BRAND.eq(brand.name())));
	}
}
