package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class ArtLikeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.ArtLike AK = Tables.ART_LIKE;

	public int countForArtId(String id) {
		return mediaCtx.fetchCount(AK, AK.ART_ID.eq(id));
	}

	public int countForArtId(Collection<String> ids) {
		return mediaCtx.fetchCount(AK, AK.ART_ID.in(ids));
	}

	public Map<String, Integer> getLikeCount(Collection<String> artIds) {
		List<Map<String, Object>> rows = mediaCtx.select(AK.ART_ID, DSL.count(AK.PUID).as("ct")).from(AK)
				.where(AK.ART_ID.in(artIds)).groupBy(AK.ART_ID).fetchMaps();
		if (ArrayMapTools.isEmpty(rows))
			return Maps.newHashMap();
		Map<String, Integer> artId2Cnt = Maps.newHashMap();
		for (Map<String, Object> has : rows) {
			if (ArrayMapTools.containsKeys(has, "artId", "ct")) {
				artId2Cnt.put(MapUtils.getString(has, "artId"), MapUtils.getInteger(has, "ct"));
			}
		}
		return artId2Cnt;
	}

	public boolean existForIdAndUid(String id, String puid) {
		return mediaCtx.fetchExists(AK, AK.ART_ID.eq(id).and(AK.PUID.eq(puid)));
	}

	public List<String> screenLike(Collection<String> artIds, String puid) {
		return mediaCtx.select(AK.ART_ID).from(AK).where(AK.ART_ID.in(artIds).and(AK.PUID.eq(puid)))
				.fetchInto(String.class);
	}

	public void addArtLike(String artId, String puid) {
		mediaCtx.insertInto(AK, AK.ART_ID, AK.PUID, AK.CREATE_TIME).values(artId, puid, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public void deleteArtLike(String artId) {
		mediaCtx.deleteFrom(AK).where(AK.ART_ID.eq(artId)).execute();
	}

	public void deleteArtLike(String artId, String puid) {
		mediaCtx.deleteFrom(AK).where(AK.ART_ID.eq(artId).and(AK.PUID.eq(puid))).execute();
	}

	public int countMyLike(String puid) {
		return mediaCtx.fetchCount(AK, AK.PUID.eq(puid));
	}

	public List<String> getMyLike(String puid, int start, int size) {
		return mediaCtx.select(AK.ART_ID).from(AK).where(AK.PUID.eq(puid)).orderBy(AK.CREATE_TIME.desc())
				.limit(start, size).fetchInto(String.class);
	}
}
