package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.ArtThemeRepository;
import com.jz.jooq.media.tables.pojos.ArtTheme;

@Lazy
@Service
public class ArtThemeService {

	@Autowired
	private ArtThemeRepository artThemeRepository;

	public int countOnlineArtTheme() {
		return artThemeRepository.countOnlineArtTheme();
	}

	public List<String> getOnlineArtThemeIds(int start, int size) {
		return artThemeRepository.getOnlineArtThemeIds(start, size);
	}

	public List<ArtTheme> findArtThemeInfo(Collection<String> ids) {
		return artThemeRepository.findArtThemeInfo(ids);
	}

	public void addArtCnt(Collection<String> ids, int cnt) {
		artThemeRepository.addArtCnt(ids, cnt);
	}
}
