package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.ArtInfoRepository;
import com.jz.jooq.media.tables.pojos.ArtInfo;

@Lazy
@Service
public class ArtInfoService {

	@Autowired
	private ArtInfoRepository artInfoRepository;
	
	public boolean existArtInfo(String id, BrandEnum brand) {
		return artInfoRepository.existArtInfo(id, brand);
	}
	
	public ArtInfo getArtInfo(String id, BrandEnum brand) {
		return artInfoRepository.getArtInfo(id, brand);
	}

	public ArtInfo getSimpleArtInfo(String id, BrandEnum brand) {
		return artInfoRepository.getSimpleArtInfo(id, brand);
	}

	public void updateOpenInfo(String id, BrandEnum brand, int isOpen) {
		artInfoRepository.updateOpenInfo(id, brand, isOpen);
	}

	public int countOpenNewArt(BrandEnum brand, Collection<String> uids, long timestamp) {
		return artInfoRepository.countOpenNewArt(brand, uids, timestamp);
	}

	public int countOpenArt(BrandEnum brand, Collection<String> uids) {
		return artInfoRepository.countOpenArt(brand, uids);
	}

	public List<String> findOpenArtIds(BrandEnum brand, Collection<String> uids, int start, int size) {
		return artInfoRepository.findOpenArtIds(brand, uids, start, size);
	}

	public List<ArtInfo> findSimpleArtInfo(Collection<String> artIds) {
		return artInfoRepository.findSimpleArtInfo(artIds);
	}
	
	public int countRecommonArts(BrandEnum brand) {
		return artInfoRepository.countRecommonArts(brand);
	}
	
	public List<String> findRecommonArtIds(BrandEnum brand, int start, int size) {
		return artInfoRepository.findRecommonArtIds(brand, start, size);
	}
}
