/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.ArtInfo;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ArtInfoRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.ArtInfo AI = Tables.ART_INFO;

    public ArtInfo getArtInfo(String id, BrandEnum brand) {
        return (ArtInfo)this.mediaCtx.selectFrom((Table)AI).where(new Condition[]{ArtInfoRepository.AI.ID.eq((Object)id).and(ArtInfoRepository.AI.BRAND.eq((Object)brand.name()))}).fetchAnyInto(ArtInfo.class);
    }

    public ArtInfo getSimpleArtInfo(String id, BrandEnum brand) {
        return (ArtInfo)this.mediaCtx.select((SelectField)ArtInfoRepository.AI.ID, (SelectField)ArtInfoRepository.AI.SCHOOL_ID, (SelectField)ArtInfoRepository.AI.LESSON_ID, (SelectField)ArtInfoRepository.AI.PUID, (SelectField)ArtInfoRepository.AI.SUID, (SelectField)ArtInfoRepository.AI.IS_OPEN).from((TableLike)AI).where(new Condition[]{ArtInfoRepository.AI.ID.eq((Object)id).and(ArtInfoRepository.AI.BRAND.eq((Object)brand.name()))}).fetchAnyInto(ArtInfo.class);
    }

    public void updateOpenInfo(String id, BrandEnum brand, int isOpen) {
        this.mediaCtx.update((Table)AI).set((Field)ArtInfoRepository.AI.IS_OPEN, (Object)isOpen).set((Field)ArtInfoRepository.AI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{ArtInfoRepository.AI.ID.eq((Object)id).and(ArtInfoRepository.AI.BRAND.eq((Object)brand.name()))}).execute();
    }

    private Condition getCondition(BrandEnum brand, Collection<String> uids) {
        return ArtInfoRepository.AI.BRAND.eq((Object)brand.name()).and(ArtInfoRepository.AI.PUID.in(uids)).and(ArtInfoRepository.AI.IS_OPEN.ge((Object)1)).and(ArtInfoRepository.AI.STATUS.eq((Object)SourceStatus.online.getCode()));
    }

    public int countOpenNewArt(BrandEnum brand, Collection<String> uids, long timestamp) {
        return this.mediaCtx.fetchCount((Table)AI, this.getCondition(brand, uids).and(ArtInfoRepository.AI.CREATE_TIME.gt((Object)timestamp)));
    }

    public int countOpenArt(BrandEnum brand, Collection<String> uids) {
        return this.mediaCtx.fetchCount((Table)AI, this.getCondition(brand, uids));
    }

    public List<String> findOpenArtIds(BrandEnum brand, Collection<String> uids, int start, int size) {
        return this.mediaCtx.select((SelectField)ArtInfoRepository.AI.ID).from((TableLike)AI).where(new Condition[]{this.getCondition(brand, uids)}).orderBy(ArtInfoRepository.AI.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<ArtInfo> findSimpleArtInfo(Collection<String> artIds) {
        return this.mediaCtx.select((SelectField)ArtInfoRepository.AI.ID, (SelectField)ArtInfoRepository.AI.PUID, (SelectField)ArtInfoRepository.AI.RESOURCE).from((TableLike)AI).where(new Condition[]{ArtInfoRepository.AI.ID.in(artIds)}).fetchInto(ArtInfo.class);
    }

    private Condition getRecommonCondition(BrandEnum brand) {
        return ArtInfoRepository.AI.BRAND.eq((Object)brand.name()).and(ArtInfoRepository.AI.IS_OPEN.ge((Object)1)).and(ArtInfoRepository.AI.STATUS.eq((Object)SourceStatus.online.getCode()));
    }

    public int countRecommonArts(BrandEnum brand) {
        return this.mediaCtx.fetchCount((Table)AI, this.getRecommonCondition(brand));
    }

    public List<String> findRecommonArtIds(BrandEnum brand, int start, int size) {
        return this.mediaCtx.select((SelectField)ArtInfoRepository.AI.ID).from((TableLike)AI).where(new Condition[]{this.getRecommonCondition(brand)}).orderBy(ArtInfoRepository.AI.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }
}

