package com.jz.jar.media.repository;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class FansRelationRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.FansRelation FR = Tables.FANS_RELATION;

	public void addFansRelation(BrandEnum brand, String puid, String fuid) {
		mediaCtx.insertInto(FR, FR.BRAND, FR.PUID, FR.FUID, FR.CREATE_TIME)
				.values(brand.name(), puid, fuid, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public void deleteMyFollow(BrandEnum brand, String puid, String fuid) {
		mediaCtx.deleteFrom(FR).where(FR.BRAND.eq(brand.name()).and(FR.PUID.eq(puid)).and(FR.FUID.eq(fuid))).execute();
	}

	public int countMyFans(BrandEnum brand, String puid) {
		return mediaCtx.fetchCount(FR, FR.BRAND.eq(brand.name()).and(FR.PUID.eq(puid)));
	}

	public List<String> getMyFans(BrandEnum brand, String puid, int start, int size) {
		return mediaCtx.select(FR.FUID).from(FR).where(FR.BRAND.eq(brand.name()).and(FR.PUID.eq(puid)))
				.orderBy(FR.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
	}

	public int countMyFollow(BrandEnum brand, String fuid) {
		return mediaCtx.fetchCount(FR, FR.BRAND.eq(brand.name()).and(FR.FUID.eq(fuid)));
	}

	public List<String> getMyFollow(BrandEnum brand, String fuid, int start, int size) {
		return mediaCtx.select(FR.PUID).from(FR).where(FR.BRAND.eq(brand.name()).and(FR.FUID.eq(fuid)))
				.orderBy(FR.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
	}
	
	/** 获取关系数量 result -> k : 粉丝数, v 关注数 */
	public Pair<Integer, Integer> getRelationCnt(BrandEnum brand, String uid) {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT COUNT(1) AS pc, t1.* FROM `fans_relation` t0,");
		sb.append(" (SELECT COUNT(1) AS fc FROM `fans_relation` WHERE `brand` = :brand AND `fuid` = :uid) t1");
		sb.append(" WHERE t0.`brand` = :brand AND t0.`puid` = :uid");
		Map<String, String> params = Maps.newHashMap();
		params.put("brand", brand.name());
		params.put("uid", uid);
		Map<String, Object> map = mediaNamedParameterJdbcTemplate.queryForMap(sb.toString(), params);
		if (ArrayMapTools.isEmpty(map))
			return Pair.of(0, 0);
		return Pair.of(MapUtils.getIntValue(map, "pc"), MapUtils.getIntValue(map, "fc"));
	}
}
