package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCollectVideo;

@Lazy
@Repository
public class UserCollectVideoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCollectVideo UCV = Tables.USER_COLLECT_VIDEO;

	public void addCollect(String uid, String pid, String wid) {
		mediaCtx.insertInto(UCV, UCV.UID, UCV.PID, UCV.WID, UCV.CREATE_TIME)
				.values(uid, pid, wid, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public List<UserCollectVideo> getCollect(String uid) {
		return mediaCtx.selectFrom(UCV).where(UCV.UID.eq(uid)).orderBy(UCV.CREATE_TIME.desc())
				.fetchInto(UserCollectVideo.class);
	}

	public int countCollect(String uid) {
		return mediaCtx.fetchCount(UCV, UCV.UID.eq(uid));
	}

	public List<UserCollectVideo> getCollect(String uid, int start, int size) {
		return mediaCtx.selectFrom(UCV).where(UCV.UID.eq(uid)).orderBy(UCV.CREATE_TIME.desc()).limit(start, size)
				.fetchInto(UserCollectVideo.class);
	}

	public boolean isCollect(String uid, String pid, String wid) {
		return mediaCtx.fetchExists(UCV, UCV.UID.eq(uid).and(UCV.PID.eq(pid)).and(UCV.WID.eq(wid)));
	}

	public void deleteCollect(String uid, String pid, String wid) {
		mediaCtx.deleteFrom(UCV).where(UCV.UID.eq(uid).and(UCV.PID.eq(pid)).and(UCV.WID.eq(wid))).execute();
	}

}
