package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.PlaylistRelationRepository;
import com.jz.jooq.media.tables.pojos.PlaylistRelation;

@Lazy
@Service
public class PlaylistRelationService {

	@Autowired
	private PlaylistRelationRepository playlistRelationRepository;

	/** 获取级别的所有分类 */
	public List<String> findTopicsForLevel(String lid) {
		return playlistRelationRepository.findTopicsForLevel(lid);
	}

	/** 获取当前专辑所有的cid */
	public List<String> getTopicsForPlaylist(String pid) {
		return playlistRelationRepository.getTopicsForPlaylist(pid);
	}

	/** 获取当前级别及分类下所有的专辑数量 */
	public int countPlaylistForLevelAndTopic(String lid, Collection<String> cidArray) {
		return playlistRelationRepository.countPlaylistForLevelAndTopic(lid, cidArray);
	}

	/** 获取当前级别及分类下所有的专辑id */
	public List<String> findPlaylistForLevelAndTopic(String lid, Collection<String> cidArray, int start, int size) {
		return playlistRelationRepository.findPlaylistForLevelAndTopic(lid, cidArray, start, size);
	}

	/** 获取当前级别及分类下所有的专辑id */
	public List<String> findPlaylistForLevelAndTopic(String lid, String cid) {
		return playlistRelationRepository.findPlaylistForLevelAndTopic(lid, cid);
	}

	/** 获取专项练习的分类id */
	public List<String> getSpecialTopics(String lid) {
		return playlistRelationRepository.getSpecialTopics(lid);
	}

	public boolean isSpecial(String lid, String pid) {
		return playlistRelationRepository.isSpecial(lid, pid);
	}

	/** 获取专项练习的分类及专辑数量 */
	public Map<String, List<String>> findSpecialTopicToPids(String lid) {
		return playlistRelationRepository.findSpecialTopicToPids(lid);
	}

	/** 根据级别和专辑id获取分类 */
	public List<String> findPlaylistTopic(String lid, Collection<String> pidArray) {
		return playlistRelationRepository.findPlaylistTopic(lid, pidArray);
	}

	/** 根据级别和分类列表获取最大播放数的专辑id */
	public Map<String, Collection<String>> findMaxWatchCntPlaylistForCids(String lid, Collection<String> cidArray,
			int cnt) {
		return playlistRelationRepository.findMaxWatchCntPlaylistForCids(lid, cidArray, cnt);
	}

	/** 根据级别和分类获取需要在首页展示的专辑id */
	public List<PlaylistRelation> findHomeShowPlaylistForLevelAndTopics(String lid, Collection<String> cids) {
		return playlistRelationRepository.findHomeShowPlaylistForLevelAndTopics(lid, cids);
	}
}
