package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class PlaylistTopicRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.PlaylistTopic PT = Tables.PLAYLIST_TOPIC;

	public int countPlaylistIds(String cid) {
		return mediaCtx.fetchCount(PT, PT.CID.eq(cid));
	}

	public List<String> findPlaylistIds(String cid) {
		return mediaCtx.select(PT.PID).from(PT).where(PT.CID.eq(cid)).orderBy(PT.SEQ.asc()).fetchInto(String.class);
	}

	public List<String> findPlaylistIds(String cid, int start, int size) {
		return mediaCtx.select(PT.PID).from(PT).where(PT.CID.eq(cid)).orderBy(PT.SEQ.asc()).limit(start, size)
				.fetchInto(String.class);
	}
}
