package com.jz.jar.media.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.HomePlaylist;

@Lazy
@Repository
public class HomePlaylistRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.HomePlaylist HP = Tables.HOME_PLAYLIST;

	private Condition getCondition(List<String> cids, String lid) {
		return HP.LID.eq(lid).and(HP.CID.in(cids));
	}

	public List<HomePlaylist> findPlaylist(List<String> cids, String lid) {
		return mediaCtx.select(HP.PID, HP.CID, HP.PIC).from(HP).where(getCondition(cids, lid)).orderBy(HP.SEQ.asc())
				.fetchInto(HomePlaylist.class);
	}

	public int countPlaylist(List<String> cids, String lid) {
		return mediaCtx.fetchCount(HP, getCondition(cids, lid));
	}
}
