package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.StudentMonthPlay;

@Lazy
@Repository
public class StudentMonthPlayRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.StudentMonthPlay SMP = Tables.STUDENT_MONTH_PLAY;

	public List<StudentMonthPlay> getStudentPlayForMonth(String month, String spuid) {
		return mediaCtx.selectFrom(SMP).where(SMP.MONTH.eq(month).and(SMP.SPUID.eq(spuid)))
				.fetchInto(StudentMonthPlay.class);
	}

	public void saveMonthPlay(String month, String spuid, int seconds, List<String> topics) {
		List<String> sqls = Lists.newArrayList();
		for (String cid : topics) {
			sqls.add("INSERT INTO `student_month_play` (`month`, `spuid`, `cid`, `seconds`) VALUES('" + month + "', '" + spuid + "', '" + cid + "', " + seconds
					+ ") ON DUPLICATE KEY UPDATE `seconds` = `seconds` + " + seconds);
		}
		String[] array = {};
		mediaJdbcTemplate.batchUpdate(sqls.toArray(array));
	}
}
