package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoImageTextRepository;
import com.jz.jooq.media.tables.pojos.TomatoImageText;

@Lazy
@Service
public class TomatoImageTextService {

	@Autowired
	private TomatoImageTextRepository tomatoImageTextRepository;

	public List<TomatoImageText> findOnlineImageText(Collection<String> iids) {
		return tomatoImageTextRepository.findOnlineImageText(iids);
	}

	public TomatoImageText getOnlineImageText(String iid) {
		return tomatoImageTextRepository.getOnlineImageText(iid);
	}

	public void addWatchCnt(String iid, int watchCnt) {
		tomatoImageTextRepository.addWatchCnt(iid, watchCnt);
	}

	public List<String> findImageTextIdForPlaylist(String pid) {
		return tomatoImageTextRepository.findImageTextIdForPlaylist(pid);
	}

	public String getFirstIIdForPid(String pid) {
		return tomatoImageTextRepository.getFirstIIdForPid(pid);
	}
	
	public Map<String, String> multiGetFirstIIdForPids(Collection<String> pid) {
		return tomatoImageTextRepository.multiGetFirstIIdForPids(pid);
	}
	
	public int countImageTextIdForPlaylist(String pid) {
		return tomatoImageTextRepository.countImageTextIdForPlaylist(pid);
	}

	public List<String> findImageTextIdForPlaylist(String pid, int start, int size) {
		return tomatoImageTextRepository.findImageTextIdForPlaylist(pid, start, size);
	}

	public boolean isExistImageTextForPlaylist(String pid, String iid) {
		return tomatoImageTextRepository.isExistImageTextForPlaylist(pid, iid);
	}

	public String getOnlinePlaylistForImageText(String iid) {
		return tomatoImageTextRepository.getOnlinePlaylistForImageText(iid);
	}

	public boolean isExistImageText(String iid) {
		return tomatoImageTextRepository.isExistImageText(iid);
	}

	public boolean isOnlineImageText(String iid) {
		return tomatoImageTextRepository.isOnlineImageText(iid);
	}

	public Map<String, List<String>> getOnlinePlaylistForImageText(Collection<String> iids) {
		return tomatoImageTextRepository.getOnlinePlaylistForImageText(iids);
	}

	public List<String> getPlaylistIdForImageText(String iid) {
		return tomatoImageTextRepository.getPlaylistIdForImageText(iid);
	}
}
