package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.OpenScreen;

@Lazy
@Repository
public class OpenScreenRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.OpenScreen OS = Tables.OPEN_SCREEN;

	public OpenScreen getCurrentOpenScreen(String brand) {
		return mediaCtx.selectFrom(OS).where(OS.BRAND.eq(brand).and(OS.STATUS.eq(1))).orderBy(OS.CREATE_TIME.desc())
				.limit(1).fetchAnyInto(OpenScreen.class);
	}

}
