package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.WorksAuthorRepository;
import com.jz.jooq.media.tables.pojos.WorksAuthor;

@Lazy
@Service
public class WorksAuthorService {

	@Autowired
	private WorksAuthorRepository worksAuthorRepository;

	public List<String> getWorksAuthors(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthors(brand, workId);
	}
	
	public List<String> getWorksAuthorParents(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthorParents(brand, workId);
	}
	
	public boolean isWorksAuthor(BrandEnum brand, String workId, String suid) {
		return worksAuthorRepository.isWorksAuthor(brand, workId, suid);
	}

	public boolean isWorksAuthorParent(BrandEnum brand, String workId, String puid) {
		return worksAuthorRepository.isWorksAuthorParent(brand, workId, puid);
	}

	public String getWorksAuthor(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthor(brand, workId);
	}

	public String getWorksAuthorParent(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthorParent(brand, workId);
	}

	public List<WorksAuthor> findWorkAuthor(BrandEnum brand, Collection<String> workIds) {
		return worksAuthorRepository.findWorkAuthor(brand, workIds);
	}

	public int countStudentWorks(BrandEnum brand, String puid, String suid) {
		return worksAuthorRepository.countStudentWorks(brand, puid, suid);
	}

	public List<String> findStudentWorksId(BrandEnum brand, String puid, String suid, int start, int size) {
		return worksAuthorRepository.findStudentWorksId(brand, puid, suid, start, size);
	}

	public List<String> findAllStudentWorksId(BrandEnum brand, String puid, String suid) {
		return worksAuthorRepository.findAllStudentWorksId(brand, puid, suid);
	}

	public List<WorksAuthor> findExistWorksInfo(Map<String, Collection<String>> school2LessonIds, String suid) {
		return worksAuthorRepository.findExistWorksInfo(school2LessonIds, suid);
	}

}
