package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.TomatoPlaylistAttributesRepository;
import com.jz.jooq.media.tables.pojos.TomatoPlaylistAttributes;

@Lazy
@Service
public class TomatoPlaylistAttributesService {

	@Autowired
	private TomatoPlaylistAttributesRepository tomatoPlaylistAttributesRepository;

	public List<String> filterPlaylistForAid(Collection<String> pids, String aid) {
		return tomatoPlaylistAttributesRepository.filterPlaylistForAid(pids, aid);
	}

	public List<String> filterPlaylistForAid(Collection<String> pids, String aid, int start, int size) {
		return tomatoPlaylistAttributesRepository.filterPlaylistForAid(pids, aid, start, size);
	}

	public int countFilterPlaylistForAid(Collection<String> pids, String aid) {
		return tomatoPlaylistAttributesRepository.countFilterPlaylistForAid(pids, aid);
	}

	public List<TomatoPlaylistAttributes> filterPlaylistForAid(Collection<String> pids, Collection<String> aids) {
		return tomatoPlaylistAttributesRepository.filterPlaylistForAid(pids, aids);
	}

	public List<String> findAttributeIds(Collection<String> pids) {
		return tomatoPlaylistAttributesRepository.findAttributeIds(pids);
	}

	public List<String> findPlaylistForAttrId(BrandEnum brand, String aid) {
		return tomatoPlaylistAttributesRepository.findPlaylistForAttrId(brand, aid);
	}

	public List<TomatoPlaylistAttributes> findPlaylistForAttrId(BrandEnum brand, Collection<String> aids) {
		return tomatoPlaylistAttributesRepository.findPlaylistForAttrId(brand, aids);
	}
}
