package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.records.ReservationRecord;

/**
 * @Title ReservationRepository
 * @Package com.jz.jar.media.repository
 * @author tangjunfeng
 * @date 2018年8月28日 下午6:33:48
 * @version V1.0
 */
@Lazy
@Repository
public class ReservationRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.Reservation RT = Tables.RESERVATION;

	public void saveRecord(ReservationRecord record) {
		mediaCtx.insertInto(RT).set(record).execute();
	}

	/** 是否存在有效的预约 */
	public boolean existValidReservation(String uid, String schoolId) {
		return mediaCtx.fetchExists(RT, RT.UID.eq(uid).and(RT.SCHOOL_ID.eq(schoolId)).and(RT.STATUS.eq(1)));
	}

	/** 是否存在预约 */
	public boolean existReservation(String uid) {
		return mediaCtx.fetchExists(RT, RT.UID.eq(uid));
	}

	public int countValidReservation(BrandEnum brand, String uid) {
		return mediaCtx.fetchCount(RT, RT.UID.eq(uid).and(RT.STATUS.eq(1)).and(RT.BRAND.eq(brand.name())));
	}

	public List<String> getReservationSchools(BrandEnum brand, String uid) {
		return mediaCtx.select(RT.SCHOOL_ID).from(RT).where(RT.UID.eq(uid).and(RT.BRAND.eq(brand.name())))
				.orderBy(RT.CREATE_TIME.asc()).fetchInto(String.class);
	}
}
