/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.Playlist;
import com.jz.jooq.media.tables.TomatoPlaylistImageText;
import com.jz.jooq.media.tables.pojos.TomatoImageText;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class TomatoImageTextRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.TomatoImageText IT = Tables.TOMATO_IMAGE_TEXT;
    private static final TomatoPlaylistImageText PI = Tables.TOMATO_PLAYLIST_IMAGE_TEXT;
    private static final Playlist P = Tables.PLAYLIST;

    public List<TomatoImageText> findOnlineImageText(Collection<String> iids) {
        return this.mediaCtx.select((SelectField)TomatoImageTextRepository.IT.ID, (SelectField)TomatoImageTextRepository.IT.NAME, (SelectField)TomatoImageTextRepository.IT.PIC, (SelectField)TomatoImageTextRepository.IT.WATCH_CNT, (SelectField)TomatoImageTextRepository.IT.LAST_UPDATED).from((TableLike)IT).where(new Condition[]{TomatoImageTextRepository.IT.ID.in(iids).and(TomatoImageTextRepository.IT.STATUS.eq((Object)AuditStatus.online.getCode()))}).fetchInto(TomatoImageText.class);
    }

    public TomatoImageText getOnlineImageText(String iid) {
        return (TomatoImageText)this.mediaCtx.selectFrom((Table)IT).where(new Condition[]{TomatoImageTextRepository.IT.ID.eq((Object)iid).and(TomatoImageTextRepository.IT.STATUS.eq((Object)AuditStatus.online.getCode()))}).fetchAnyInto(TomatoImageText.class);
    }

    public boolean isExistImageText(String iid) {
        return this.mediaCtx.fetchExists((Table)IT, TomatoImageTextRepository.IT.ID.eq((Object)iid));
    }

    public boolean isOnlineImageText(String iid) {
        return this.mediaCtx.fetchExists((Table)IT, TomatoImageTextRepository.IT.ID.eq((Object)iid).and(TomatoImageTextRepository.IT.STATUS.eq((Object)AuditStatus.online.getCode())));
    }

    public void addWatchCnt(String iid, int watchCnt) {
        this.mediaCtx.update((Table)IT).set((Field)TomatoImageTextRepository.IT.WATCH_CNT, TomatoImageTextRepository.IT.WATCH_CNT.add((Number)watchCnt)).where(new Condition[]{TomatoImageTextRepository.IT.ID.eq((Object)iid)}).execute();
    }

    public List<String> findImageTextIdForPlaylist(String pid) {
        return this.mediaCtx.select((SelectField)TomatoImageTextRepository.PI.IID).from((TableLike)PI).where(new Condition[]{TomatoImageTextRepository.PI.PID.eq((Object)pid)}).orderBy(TomatoImageTextRepository.PI.SEQ.asc()).fetchInto(String.class);
    }

    public int countImageTextIdForPlaylist(String pid) {
        return this.mediaCtx.fetchCount((Table)PI, TomatoImageTextRepository.PI.PID.eq((Object)pid));
    }

    public List<String> findImageTextIdForPlaylist(String pid, int start, int size) {
        return this.mediaCtx.select((SelectField)TomatoImageTextRepository.PI.IID).from((TableLike)PI).where(new Condition[]{TomatoImageTextRepository.PI.PID.eq((Object)pid)}).orderBy(TomatoImageTextRepository.PI.SEQ.asc()).limit(start, size).fetchInto(String.class);
    }

    public boolean isExistImageTextForPlaylist(String pid, String iid) {
        return this.mediaCtx.fetchExists((Table)PI, TomatoImageTextRepository.PI.PID.eq((Object)pid).and(TomatoImageTextRepository.PI.IID.eq((Object)iid)));
    }

    public String getOnlinePlaylistForImageText(String iid) {
        return (String)this.mediaCtx.select((SelectField)TomatoImageTextRepository.PI.PID).from((TableLike)PI.join((TableLike)P).on(new Condition[]{TomatoImageTextRepository.PI.PID.eq((Field)TomatoImageTextRepository.P.PID)})).where(new Condition[]{TomatoImageTextRepository.PI.IID.eq((Object)iid).and(TomatoImageTextRepository.P.STATUS.eq((Object)DbField.online.name()))}).fetchAnyInto(String.class);
    }

    public Map<String, List<String>> getOnlinePlaylistForImageText(Collection<String> iids) {
        return this.mediaCtx.select((SelectField)TomatoImageTextRepository.PI.IID, (SelectField)TomatoImageTextRepository.PI.PID).from((TableLike)PI.join((TableLike)P).on(new Condition[]{TomatoImageTextRepository.PI.PID.eq((Field)TomatoImageTextRepository.P.PID)})).where(new Condition[]{TomatoImageTextRepository.PI.IID.in(iids).and(TomatoImageTextRepository.P.STATUS.eq((Object)DbField.online.name()))}).fetchGroups((Field)TomatoImageTextRepository.PI.IID, (Field)TomatoImageTextRepository.PI.PID);
    }

    public List<String> getPlaylistIdForImageText(String iid) {
        return this.mediaCtx.select((SelectField)TomatoImageTextRepository.PI.PID).from((TableLike)PI).where(new Condition[]{TomatoImageTextRepository.PI.IID.eq((Object)iid)}).fetchInto(String.class);
    }
}

