package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.UploadVideoStatus;
import com.jz.jar.media.repository.UploadVideoRepository;
import com.jz.jooq.media.tables.pojos.UploadVideo;
import com.jz.jooq.media.tables.records.UploadVideoRecord;

@Lazy
@Service
public class UploadVideoService {

	@Autowired
	private UploadVideoRepository uploadVideoRepository;

	public void saveToWaiting(String wid, String uid, String name, String app) {
		uploadVideoRepository.saveToWaiting(wid, uid, name, app);
	}
	
	public void updateVideoInfo(UploadVideoRecord record) {
		uploadVideoRepository.updateVideoInfo(record);
	}
	
	public int countVideos(String uid, Collection<UploadVideoStatus> status, String app) {
		return uploadVideoRepository.countVideos(uid, status, app);
	}

	public List<String> getVideos(String uid, Collection<UploadVideoStatus> status, String app, int start, int size) {
		return uploadVideoRepository.getVideos(uid, status, app, start, size);
	}

	public List<UploadVideo> getVideoInfo(Collection<String> wids) {
		return uploadVideoRepository.getVideoInfo(wids);
	}

	public int countOnlineVideosForNotUid(String uid, String app) {
		return uploadVideoRepository.countOnlineVideosForNotUid(uid, app);
	}

	public List<String> getOnlineVideosForNotUid(String uid, String app, int start, int size) {
		return uploadVideoRepository.getOnlineVideosForNotUid(uid, app, start, size);
	}
	
	public List<String> getOnlineVideos(String uid, Collection<String> wids) {
		return uploadVideoRepository.getOnlineVideos(uid, wids);
	}
	
	public void deleteVideos(String uid, Collection<String> wids) {
		uploadVideoRepository.deleteVideos(uid, wids);
	}
	
	public UploadVideo getOnlineVideo(String uid, String wid) {
		return uploadVideoRepository.getOnlineVideo(uid, wid);
	}
	
	public List<String> getOnlineVideoIds(String uid) {
		return uploadVideoRepository.getOnlineVideoIds(uid);
	}
	
	public UploadVideo getVideo(String wid){
		return uploadVideoRepository.getVideo(wid);
	}
}
