package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class ReservationProvRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.ReservationProv RP = Tables.RESERVATION_PROV;

	public void saveProv(String prov, String uid, int cnt) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(RP, RP.PROV, RP.UID, RP.CNT, RP.CREATE_TIME, RP.LAST_UPDATED)
				.values(prov, uid, cnt, timeMillis, timeMillis).onDuplicateKeyUpdate().set(RP.CNT, RP.CNT.add(cnt))
				.set(RP.LAST_UPDATED, timeMillis).execute();
	}
}
