package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoWeekVideo;

@Lazy
@Repository
public class TomatoWeekRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoWeekVideo TWV = Tables.TOMATO_WEEK_VIDEO;
	private static final com.jz.jooq.media.tables.TomatoWeekData TWD = Tables.TOMATO_WEEK_DATA;

	// public TomatoWeekVideo getCurrentVideo(int days, int type, String
	// currentDate) {
	// return
	// mediaCtx.selectFrom(TWV).where(TWV.DAYS.eq(days).and(TWV.TYPE.eq(type)).and(TWV.WEEK.le(currentDate)))
	// .orderBy(TWV.WEEK.desc()).limit(1).fetchAnyInto(TomatoWeekVideo.class);
	// }

	public List<TomatoWeekVideo> getWeekVideos(String week, int maxDays) {
		return mediaCtx.selectFrom(TWV).where(TWV.WEEK.eq(week).and(TWV.DAYS.le(maxDays)))
				.orderBy(TWV.DAYS.asc(), TWV.TYPE.asc()).fetchInto(TomatoWeekVideo.class);
	}

	public void increNum(String week, int num) {
		mediaCtx.insertInto(TWD, TWD.WEEK, TWD.NUM).values(week, num).onDuplicateKeyUpdate()
				.set(TWD.NUM, TWD.NUM.add(num)).execute();

	}

	public int getNum(String week) {
		Integer rs = mediaCtx.select(TWD.NUM).from(TWD).where(TWD.WEEK.eq(week)).fetchAnyInto(Integer.class);
		return rs != null ? rs : 0;
	}

}
