/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.WorksTreasure;
import com.jz.jooq.media.tables.records.WorksTreasureRecord;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableRecord;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class WorksTreasureRepository
extends MediaBaseRepository {
    private static final WorksTreasure WT = Tables.WORKS_TREASURE;

    public void createTreasure(WorksTreasureRecord record) {
        this.mediaCtx.batchInsert(new TableRecord[]{record}).execute();
    }

    public com.jz.jooq.media.tables.pojos.WorksTreasure getTreasureById(String id) {
        return (com.jz.jooq.media.tables.pojos.WorksTreasure)this.mediaCtx.selectFrom((Table)WT).where(new Condition[]{WorksTreasureRepository.WT.ID.eq((Object)id)}).fetchAnyInto(com.jz.jooq.media.tables.pojos.WorksTreasure.class);
    }

    public com.jz.jooq.media.tables.pojos.WorksTreasure getPayedTreasureByWorkId(String workId) {
        return (com.jz.jooq.media.tables.pojos.WorksTreasure)this.mediaCtx.selectFrom((Table)WT).where(new Condition[]{WorksTreasureRepository.WT.WORK_ID.eq((Object)workId).and(WorksTreasureRepository.WT.STATUS.eq((Object)1))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.WorksTreasure.class);
    }

    public List<com.jz.jooq.media.tables.pojos.WorksTreasure> mutiGetPayedTreasureByWorkIds(Collection<String> workIds) {
        return this.mediaCtx.selectFrom((Table)WT).where(new Condition[]{WorksTreasureRepository.WT.WORK_ID.in(workIds).and(WorksTreasureRepository.WT.STATUS.eq((Object)1))}).fetchInto(com.jz.jooq.media.tables.pojos.WorksTreasure.class);
    }

    public List<String> filterPayedWorkIds(Collection<String> workIds) {
        return this.mediaCtx.select((SelectField)WorksTreasureRepository.WT.WORK_ID).from((TableLike)WT).where(new Condition[]{WorksTreasureRepository.WT.WORK_ID.in(workIds).and(WorksTreasureRepository.WT.STATUS.eq((Object)1))}).fetchInto(String.class);
    }

    public List<com.jz.jooq.media.tables.pojos.WorksTreasure> getRecomTreasures(int size) {
        return this.mediaCtx.selectFrom((Table)WT).where(new Condition[]{WorksTreasureRepository.WT.RECOM.eq((Object)1).and(WorksTreasureRepository.WT.STATUS.eq((Object)1))}).orderBy(WorksTreasureRepository.WT.WEIGHT.desc()).limit(size).fetchInto(com.jz.jooq.media.tables.pojos.WorksTreasure.class);
    }

    public void finishPay(String orderId, BigDecimal payMoney, String paymentMode, String onlinePayTradeId) {
        this.mediaCtx.update((Table)WT).set((Field)WorksTreasureRepository.WT.PAY_MONEY, (Object)payMoney).set((Field)WorksTreasureRepository.WT.PAYMENT_MODE, (Object)paymentMode).set((Field)WorksTreasureRepository.WT.ONLINE_PAY_TRADE_ID, (Object)onlinePayTradeId).set((Field)WorksTreasureRepository.WT.STATUS, (Object)1).set((Field)WorksTreasureRepository.WT.REGISTER_STATUS, (Object)0).set((Field)WorksTreasureRepository.WT.PAY_TIME, (Object)System.currentTimeMillis()).where(new Condition[]{WorksTreasureRepository.WT.ID.eq((Object)orderId)}).execute();
    }

    public int cntRecomTreasurePage() {
        return this.mediaCtx.fetchCount((Table)WT, WorksTreasureRepository.WT.RECOM.eq((Object)1).and(WorksTreasureRepository.WT.STATUS.eq((Object)1)));
    }

    public List<com.jz.jooq.media.tables.pojos.WorksTreasure> getRecomTreasurePage(int start, int size) {
        return this.mediaCtx.selectFrom((Table)WT).where(new Condition[]{WorksTreasureRepository.WT.RECOM.eq((Object)1).and(WorksTreasureRepository.WT.STATUS.eq((Object)1))}).orderBy(WorksTreasureRepository.WT.WEIGHT.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.WorksTreasure.class);
    }
}

