package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.RedeemActivity;
import com.jz.jooq.media.tables.pojos.RedeemActivityBatch;
import com.jz.jooq.media.tables.pojos.RedeemGift;
import com.jz.jooq.media.tables.pojos.RedeemInfo;
import com.jz.jooq.media.tables.records.RedeemGiftRecord;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class RedeemRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.RedeemActivity RA = Tables.REDEEM_ACTIVITY;
	private static final com.jz.jooq.media.tables.RedeemActivityBatch RAB = Tables.REDEEM_ACTIVITY_BATCH;
	private static final com.jz.jooq.media.tables.RedeemInfo RI = Tables.REDEEM_INFO;
	private static final com.jz.jooq.media.tables.RedeemGift RG = Tables.REDEEM_GIFT;

	public RedeemActivity getActivity(String activityId) {
		return mediaCtx.selectFrom(RA).where(RA.ACTIVITY_ID.eq(activityId)).fetchAnyInto(RedeemActivity.class);
	}

	public Map<String, String> mutiGetActivityId2NameMap(Collection<String> activityIds) {
		return mediaCtx.select(RA.ACTIVITY_ID, RA.NAME).from(RA).where(RA.ACTIVITY_ID.in(activityIds))
				.fetchMap(RA.ACTIVITY_ID, RA.NAME);
	}

	public RedeemActivityBatch getBatch(String batchId) {
		return mediaCtx.selectFrom(RAB).where(RAB.BATCH_ID.eq(batchId)).fetchAnyInto(RedeemActivityBatch.class);
	}

	public RedeemInfo getRedeemInfo(String redeemCode) {
		return mediaCtx.selectFrom(RI).where(RI.REDEEM_CODE.eq(redeemCode)).fetchAnyInto(RedeemInfo.class);
	}

	public boolean existOtherJoined(String puid, String activityId) {
		return mediaCtx.fetchExists(RI, RI.PUID.eq(puid).and(RI.ACTIVITY_ID.eq(activityId)));
	}

	public void fetchRedeem(String redeemCode, String puid, String suid, String schoolId, int type, long fetchTime) {
		mediaCtx.update(RI).set(RI.PUID, puid).set(RI.SUID, suid).set(RI.SCHOOL_ID, schoolId).set(RI.TYPE, type)
				.set(RI.FETCH_TIME, fetchTime).where(RI.REDEEM_CODE.eq(redeemCode)).execute();
	}

	public int cntMyRedeemPage(String puid) {
		return mediaCtx.fetchCount(RI, RI.PUID.eq(puid));
	}

	public List<RedeemInfo> getMyRedeemPage(String puid, int start, int size) {
		return mediaCtx.selectFrom(RI).where(RI.PUID.eq(puid)).orderBy(RI.FETCH_TIME.desc()).limit(start, size)
				.fetchInto(RedeemInfo.class);
	}

	public void createGifts(List<RedeemGiftRecord> records) {
		mediaCtx.batchInsert(records).execute();
	}

	public List<RedeemGift> getRedeemGifts(String redeemCode) {
		return mediaCtx.selectFrom(RG).where(RG.REDEEM_CODE.in(redeemCode)).orderBy(RG.ID.asc())
				.fetchInto(RedeemGift.class);
	}

}
