package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.QuizStudentScore;

@Lazy
@Repository
public class QuizStudentScoreRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.QuizStudentScore QSS = Tables.QUIZ_STUDENT_SCORE;

	public void saveStudentScore(String suid, int week, String qzid, int score, int totalScore) {
		mediaCtx.insertInto(QSS, QSS.SUID, QSS.WEEK, QSS.QZID, QSS.SCORE, QSS.TOTAL_SCORE)
				.values(suid, week, qzid, score, totalScore).onDuplicateKeyUpdate().set(QSS.SCORE, score).execute();
	}

	public QuizStudentScore getStudentScore(String suid, int week) {
		List<QuizStudentScore> list = mediaCtx.selectFrom(QSS).where(QSS.SUID.eq(suid).and(QSS.WEEK.eq(week)))
				.fetchInto(QuizStudentScore.class);
		return ArrayMapTools.isEmpty(list) ? null : list.get(0);
	}

}
