package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserAiDayLearn;
import com.jz.jooq.media.tables.pojos.UserAiHomework;
import com.jz.jooq.media.tables.pojos.UserAiLesson;
import com.jz.jooq.media.tables.pojos.UserAiLessonSection;
import com.jz.jooq.media.tables.pojos.UserAiPack;
import com.jz.jooq.media.tables.records.UserAiHomeworkRecord;

@Repository
public class UserAiRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserAiHomework UAH = Tables.USER_AI_HOMEWORK;
	private static final com.jz.jooq.media.tables.UserAiPack UAP = Tables.USER_AI_PACK;
	private static final com.jz.jooq.media.tables.UserAiLesson UAL = Tables.USER_AI_LESSON;
	private static final com.jz.jooq.media.tables.UserAiLessonSection UALS = Tables.USER_AI_LESSON_SECTION;
	private static final com.jz.jooq.media.tables.AiHomeworkLike AHL = Tables.AI_HOMEWORK_LIKE;
	private static final com.jz.jooq.media.tables.UserAiDayLearn UADL = Tables.USER_AI_DAY_LEARN;
	private static final com.jz.jooq.media.tables.AiAbcLessonLike AALL = Tables.AI_ABC_LESSON_LIKE;
	private static final com.jz.jooq.media.tables.UserAiDayWords UADW = Tables.USER_AI_DAY_WORDS;

	public List<UserAiHomework> getHomeworks(String suid, String pid, String aid) {
		return mediaCtx.selectFrom(UAH).where(UAH.SUID.eq(suid).and(UAH.PID.eq(pid)).and(UAH.AID.eq(aid)))
				.fetchInto(UserAiHomework.class);
	}

	public List<UserAiHomework> mutiGetHomework(String suid, String pid, String aid, Collection<String> materialIds) {
		return mediaCtx.selectFrom(UAH)
				.where(UAH.SUID.eq(suid).and(UAH.PID.eq(pid)).and(UAH.AID.eq(aid)).and(UAH.MATERIAL_ID.in(materialIds)))
				.fetchInto(UserAiHomework.class);
	}

	public void savePack(String uid, String suid, String pid, long openTime) {
		mediaCtx.insertInto(UAP, UAP.UID, UAP.SUID, UAP.PID, UAP.OPEN_TIME, UAP.CREATE_TIME)
				.values(uid, suid, pid, openTime, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public UserAiPack getPack(String uid, String pid) {
		return mediaCtx.selectFrom(UAP).where(UAP.UID.eq(uid).and(UAP.PID.eq(pid))).fetchAnyInto(UserAiPack.class);
	}
	
	public List<UserAiPack> getUserPacks(String uid) {
		return mediaCtx.selectFrom(UAP).where(UAP.UID.eq(uid)).fetchInto(UserAiPack.class);
	}

	public void saveLesson(String suid, String pid, String aid, int status, String currentSectionId,
			String currentMaterialId, Long finishTime) {
		long current = System.currentTimeMillis();
		mediaCtx.insertInto(UAL, UAL.SUID, UAL.PID, UAL.AID, UAL.STATUS, UAL.CREATE_TIME, UAL.CURRENT_SECTION_ID,
				UAL.CURRENT_MATERIAL_ID, UAL.FINISH_TIME)
				.values(suid, pid, aid, status, current, currentSectionId, currentMaterialId, finishTime)
				.onDuplicateKeyUpdate().set(UAL.STATUS, status).set(UAL.CURRENT_SECTION_ID, currentSectionId)
				.set(UAL.CURRENT_MATERIAL_ID, currentMaterialId).set(UAL.CREATE_TIME, current)
				.set(UAL.FINISH_TIME, finishTime).execute();
	}

	public Map<String, Integer> mutiCalFinishNum(String suid, Collection<String> pids) {
		return mediaCtx.select(UAL.PID, DSL.count()).from(UAL)
				.where(UAL.SUID.eq(suid).and(UAL.PID.in(pids)).and(UAL.STATUS.eq(2))).groupBy(UAL.PID)
				.fetchMap(UAL.PID, DSL.count());
	}

	public List<UserAiLesson> getLessons(String suid, String pid) {
		return mediaCtx.selectFrom(UAL).where(UAL.SUID.eq(suid).and(UAL.PID.eq(pid))).orderBy(UAL.CREATE_TIME.desc())
				.fetchInto(UserAiLesson.class);
	}

	public UserAiLesson getLesson(String suid, String pid, String aid) {
		return mediaCtx.selectFrom(UAL).where(UAL.SUID.eq(suid).and(UAL.PID.eq(pid)).and(UAL.AID.eq(aid)))
				.fetchAnyInto(UserAiLesson.class);
	}

	public void saveSection(String suid, String pid, String aid, String sectionId, int status,
			String currentMaterialId) {
		mediaCtx.insertInto(UALS, UALS.SUID, UALS.PID, UALS.AID, UALS.SECTION_ID, UALS.STATUS, UALS.CREATE_TIME,
				UALS.CURRENT_MATERIAL_ID)
				.values(suid, pid, aid, sectionId, status, System.currentTimeMillis(), currentMaterialId)
				.onDuplicateKeyUpdate().set(UALS.STATUS, status).set(UALS.CURRENT_MATERIAL_ID, currentMaterialId)
				.execute();
	}

	public List<UserAiLessonSection> getSections(String suid, String pid, String aid) {
		return mediaCtx.selectFrom(UALS).where(UALS.SUID.eq(suid).and(UALS.PID.eq(pid)).and(UALS.AID.eq(aid)))
				.fetchInto(UserAiLessonSection.class);
	}

	public UserAiLessonSection getSection(String suid, String pid, String aid, String sectionId) {
		return mediaCtx.selectFrom(UALS).where(
				UALS.SUID.eq(suid).and(UALS.PID.eq(pid)).and(UALS.AID.eq(aid)).and(UALS.SECTION_ID.eq(sectionId)))
				.fetchAnyInto(UserAiLessonSection.class);
	}

	public Map<Long, Integer> cntCampUser(String pid) {
		return mediaCtx.select(UAP.OPEN_TIME, DSL.count()).from(UAP).where(UAP.PID.eq(pid)).groupBy(UAP.OPEN_TIME)
				.fetchMap(UAP.OPEN_TIME, DSL.count());
	}

	public int cntUserByCamp(String pid, long openTime) {
		return mediaCtx.fetchCount(UAP, UAP.PID.eq(pid).and(UAP.OPEN_TIME.eq(openTime)));
	}

	public List<String> getCampSuids(String pid, Long openTime) {
		return mediaCtx.select(UAP.SUID).from(UAP).where(UAP.PID.eq(pid).and(UAP.OPEN_TIME.eq(openTime)))
				.fetchInto(String.class);
	}

	public List<UserAiHomework> getLessonHomeworksWithPic(String pid, String aid, Collection<String> suids,
			Collection<String> materialIds, int start, int size) {
		return mediaCtx.selectFrom(UAH)
				.where(UAH.PID.eq(pid).and(UAH.AID.eq(aid)).and(UAH.SUID.in(suids)).and(UAH.MATERIAL_ID.in(materialIds))
						.and(UAH.PIC.isNotNull()))
				.orderBy(UAH.LIKE_CNT.desc(), UAH.CREATE_TIME.asc()).limit(start, size).fetchInto(UserAiHomework.class);
	}

	public UserAiHomework getHomework(String hid) {
		return mediaCtx.selectFrom(UAH).where(UAH.HID.eq(hid)).fetchAnyInto(UserAiHomework.class);
	}

	public boolean existForIdAndUid(String hid, String suid) {
		return mediaCtx.fetchExists(AHL, AHL.HID.eq(hid).and(AHL.SUID.eq(suid)));
	}

	public void addHomeworkLike(String hid, String suid) {
		mediaCtx.insertInto(AHL, AHL.HID, AHL.SUID, AHL.CREATE_TIME).values(hid, suid, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public void deleteHomeworkLike(String hid, String suid) {
		mediaCtx.deleteFrom(AHL).where(AHL.HID.eq(hid).and(AHL.SUID.eq(suid))).execute();
	}

	public void addLikeCnt(String hid, int cnt) {
		mediaCtx.update(UAH).set(UAH.LIKE_CNT, UAH.LIKE_CNT.add(cnt)).where(UAH.HID.eq(hid)).execute();
	}

	public int cntLessonHomeworksWithPic(String pid, String aid, Collection<String> suids) {
		return mediaCtx.fetchCount(UAH,
				UAH.PID.eq(pid).and(UAH.AID.eq(aid)).and(UAH.SUID.in(suids)).and(UAH.PIC.isNotNull()));
	}

	public UserAiHomework getHomeWork(String suid, String pid, String aid, String sectionId, String materialId) {
		return mediaCtx
				.selectFrom(UAH).where(UAH.SUID.eq(suid).and(UAH.PID.eq(pid)).and(UAH.AID.eq(aid))
						.and(UAH.SECTION_ID.eq(sectionId)).and(UAH.MATERIAL_ID.eq(materialId)))
				.fetchAnyInto(UserAiHomework.class);
	}

	public void saveHomework(UserAiHomeworkRecord hRecord) {
		mediaCtx.insertInto(UAH).set(hRecord).onDuplicateKeyUpdate().set(hRecord).execute();
	}

	public UserAiHomework getFirstPicAudioHomework(String suid, String pid, String aid) {
		return mediaCtx.selectFrom(UAH)
				.where(UAH.SUID.eq(suid).and(UAH.PID.eq(pid)).and(UAH.AID.eq(aid)).and(UAH.PIC.isNotNull())
						.and(UAH.AUDIO.isNotNull()))
				.orderBy(UAH.CREATE_TIME.asc()).limit(1).fetchAnyInto(UserAiHomework.class);
	}

	public List<String> getUserLearnLessons(String suid, String pid) {
		return mediaCtx.select(UAL.AID).from(UAL).where(UAL.SUID.eq(suid).and(UAL.PID.eq(pid))).fetchInto(String.class);
	}

	public Integer cntUserPackPics(String suid, String pid) {
		return mediaCtx.fetchCount(UAH, UAH.SUID.eq(suid).and(UAH.PID.eq(pid)).and(UAH.PIC.isNotNull()));
	}

	public List<String> mutiGetLikedHids(String suid, Collection<String> hids) {
		return mediaCtx.select(AHL.HID).from(AHL).where(AHL.SUID.eq(suid).and(AHL.HID.in(hids)))
				.fetchInto(String.class);
	}

	public int cntABCLessonHaveWorksSuids(String pid, String aid, Collection<String> suids) {
		return mediaCtx.fetchCount(UAL,
				UAL.SUID.in(suids).and(UAL.PID.eq(pid)).and(UAL.AID.eq(aid)).and(UAL.HAVE_WORKS.eq(1)));
	}

	public void recordUserAiDayLearn(String day, String suid, String aid, Integer learnTime) {
		mediaCtx.insertInto(UADL).set(UADL.DAY, day).set(UADL.SUID, suid).set(UADL.AID, aid)
				.set(UADL.LEARN_TIME, learnTime).onDuplicateKeyUpdate()
				.set(UADL.LEARN_TIME, UADL.LEARN_TIME.add(learnTime)).execute();
	}

	public UserAiDayLearn getUserAiDayLearn(String day, String suid, String aid) {
		return mediaCtx.selectFrom(UADL).where(UADL.DAY.eq(day).and(UADL.SUID.eq(suid)).and(UADL.AID.eq(aid)))
				.fetchAnyInto(UserAiDayLearn.class);
	}

	public boolean existForABCLike(String suid, String pid, String aid, String likedSuid) {
		return mediaCtx.fetchExists(AALL,
				AALL.SUID.eq(suid).and(AALL.PID.eq(pid)).and(AALL.AID.eq(aid)).and(AALL.LIKED_SUID.eq(likedSuid)));
	}

	public Map<String, Integer> getABCLessonHaveWorksSuids(String pid, String aid, Collection<String> suids, int start,
			int size) {
		return mediaCtx.select(UAL.SUID, UAL.LIKE_CNT).from(UAL)
				.where(UAL.SUID.in(suids).and(UAL.PID.eq(pid)).and(UAL.AID.eq(aid)).and(UAL.HAVE_WORKS.eq(1)))
				.orderBy(UAL.LIKE_CNT.desc()).limit(start, size).fetchMap(UAL.SUID, UAL.LIKE_CNT);
	}

	public List<UserAiHomework> getLessonHomeworks(String pid, String aid, Collection<String> suids,
			Collection<String> materialIds) {
		return mediaCtx.selectFrom(UAH)
				.where(UAH.PID.eq(pid).and(UAH.AID.eq(aid)).and(UAH.SUID.in(suids))
						.and(UAH.MATERIAL_ID.in(materialIds)))
				.orderBy(UAH.CREATE_TIME.asc()).fetchInto(UserAiHomework.class);
	}

	public List<String> mutiGetLikedABCSuids(String suid, String pid, String aid) {
		return mediaCtx.select(AALL.SUID).from(AALL)
				.where(AALL.PID.eq(pid).and(AALL.AID.eq(aid)).and(AALL.LIKED_SUID.eq(suid))).fetchInto(String.class);
	}

	public void addABCLessonLike(String likeSuid, String pid, String aid, String suid) {
		mediaCtx.insertInto(AALL, AALL.SUID, AALL.PID, AALL.AID, AALL.LIKED_SUID, AALL.CREATE_TIME)
				.values(likeSuid, pid, aid, suid, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public void deleteABCLessonLike(String likeSuid, String pid, String aid, String suid) {
		mediaCtx.deleteFrom(AALL)
				.where(AALL.SUID.eq(likeSuid).and(AALL.PID.eq(pid)).and(AALL.AID.eq(aid)).and(AALL.LIKED_SUID.eq(suid)))
				.execute();
	}

	public void addABCLessonLikeCnt(String suid, String pid, String aid, int cnt) {
		mediaCtx.update(UAL).set(UAL.LIKE_CNT, UAL.LIKE_CNT.add(cnt))
				.where(UAL.SUID.eq(suid).and(UAL.PID.eq(pid)).and(UAL.AID.eq(aid))).execute();
	}

	public void updateLessonHaveWorks(String suid, String pid, String aid) {
		mediaCtx.update(UAL).set(UAL.HAVE_WORKS, 1).where(UAL.SUID.eq(suid).and(UAL.PID.eq(pid)).and(UAL.AID.eq(aid)))
				.execute();
	}

	public void recordUserAiDayWords(String day, String suid, String materialId) {
		mediaCtx.insertInto(UADW).set(UADW.DAY, day).set(UADW.SUID, suid).set(UADW.MATERIAL_ID, materialId)
				.onDuplicateKeyIgnore().execute();
	}

	public int getUserAiDayWords(String day, String suid) {
		return mediaCtx.fetchCount(UADW, UADW.DAY.eq(day).and(UADW.SUID.eq(suid)));
	}

}
