/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.UserPlayHistory;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserPlayHistoryRepository
extends MediaBaseRepository {
    private static final UserPlayHistory UPH = Tables.USER_PLAY_HISTORY;

    public void save(String uid, String pid, String wid, int playLength, String nextWid, BrandEnum brand) {
        long timeMillis = System.currentTimeMillis();
        this.mediaCtx.insertInto((Table)UPH, (Field)UserPlayHistoryRepository.UPH.UID, (Field)UserPlayHistoryRepository.UPH.PID, (Field)UserPlayHistoryRepository.UPH.WID, (Field)UserPlayHistoryRepository.UPH.PLAY_LENGTH, (Field)UserPlayHistoryRepository.UPH.NEXT_WID, (Field)UserPlayHistoryRepository.UPH.BRAND, (Field)UserPlayHistoryRepository.UPH.CREATE_TIME).values((Object)uid, (Object)pid, (Object)wid, (Object)playLength, (Object)nextWid, (Object)brand.name(), (Object)timeMillis).onDuplicateKeyUpdate().set((Field)UserPlayHistoryRepository.UPH.WID, (Object)wid).set((Field)UserPlayHistoryRepository.UPH.PLAY_LENGTH, (Object)playLength).set((Field)UserPlayHistoryRepository.UPH.NEXT_WID, (Object)nextWid).set((Field)UserPlayHistoryRepository.UPH.CREATE_TIME, (Object)timeMillis).execute();
    }

    public int countPlayHistory(String uid, BrandEnum brand) {
        return this.mediaCtx.fetchCount((Table)UPH, UserPlayHistoryRepository.UPH.UID.eq((Object)uid).and(UserPlayHistoryRepository.UPH.BRAND.eq((Object)brand.name())));
    }

    public List<com.jz.jooq.media.tables.pojos.UserPlayHistory> getPlayHistory(String uid, BrandEnum brand, int start, int size) {
        return this.mediaCtx.selectFrom((Table)UPH).where(new Condition[]{UserPlayHistoryRepository.UPH.UID.eq((Object)uid).and(UserPlayHistoryRepository.UPH.BRAND.eq((Object)brand.name()))}).orderBy(UserPlayHistoryRepository.UPH.CREATE_TIME.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.UserPlayHistory.class);
    }

    public void deleteHistory(String uid, String pid) {
        this.mediaCtx.deleteFrom((Table)UPH).where(new Condition[]{UserPlayHistoryRepository.UPH.UID.eq((Object)uid).and(UserPlayHistoryRepository.UPH.PID.eq((Object)pid))}).execute();
    }

    public void deleteHistory(String uid, int cnt) {
        String sql = "DELETE FROM `media`.`user_play_history` WHERE uid = ? ORDER BY `create_time` ASC LIMIT ?";
        this.mediaJdbcTemplate.update(sql, new Object[]{uid, cnt});
    }

    public com.jz.jooq.media.tables.pojos.UserPlayHistory getHistory(String uid, String pid, BrandEnum brand) {
        List histories = this.mediaCtx.selectFrom((Table)UPH).where(new Condition[]{UserPlayHistoryRepository.UPH.UID.eq((Object)uid).and(UserPlayHistoryRepository.UPH.PID.eq((Object)pid)).and(UserPlayHistoryRepository.UPH.BRAND.eq((Object)brand.name()))}).fetchInto(com.jz.jooq.media.tables.pojos.UserPlayHistory.class);
        return ArrayMapTools.isNotEmpty((Collection)histories) ? (com.jz.jooq.media.tables.pojos.UserPlayHistory)histories.get(0) : null;
    }

    public List<com.jz.jooq.media.tables.pojos.UserPlayHistory> getHistories(String uid, Collection<String> pidArray) {
        return this.mediaCtx.selectFrom((Table)UPH).where(new Condition[]{UserPlayHistoryRepository.UPH.UID.eq((Object)uid).and(UserPlayHistoryRepository.UPH.PID.in(pidArray))}).fetchInto(com.jz.jooq.media.tables.pojos.UserPlayHistory.class);
    }

    public List<String> getHistoryPids(String uid) {
        return this.mediaCtx.selectDistinct((SelectField)UserPlayHistoryRepository.UPH.PID).from((TableLike)UPH).where(new Condition[]{UserPlayHistoryRepository.UPH.UID.eq((Object)uid)}).fetchInto(String.class);
    }
}

