/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.google.common.collect.Maps;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.WorksAuthorRepository;
import com.jz.jooq.media.tables.pojos.WorksAuthor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class WorksAuthorService {
    @Autowired
    private WorksAuthorRepository worksAuthorRepository;

    public List<String> getWorksAuthors(BrandEnum brand, String workId) {
        return this.worksAuthorRepository.getWorksAuthors(brand, workId);
    }

    public List<String> getWorksAuthorParents(BrandEnum brand, String workId) {
        return this.worksAuthorRepository.getWorksAuthorParents(brand, workId);
    }

    public boolean isWorksAuthor(BrandEnum brand, String workId, String suid) {
        return this.worksAuthorRepository.isWorksAuthor(brand, workId, suid);
    }

    public boolean isWorksAuthorParent(BrandEnum brand, String workId, String puid) {
        return this.worksAuthorRepository.isWorksAuthorParent(brand, workId, puid);
    }

    public String getWorksAuthor(BrandEnum brand, String workId) {
        return this.worksAuthorRepository.getWorksAuthor(brand, workId);
    }

    public String getWorksAuthorParent(BrandEnum brand, String workId) {
        return this.worksAuthorRepository.getWorksAuthorParent(brand, workId);
    }

    public List<WorksAuthor> findWorkAuthor(BrandEnum brand, Collection<String> workIds) {
        return this.worksAuthorRepository.findWorkAuthor(brand, workIds);
    }

    public int countStudentWorks(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen) {
        return this.worksAuthorRepository.countStudentWorks(brand, puids, suid, isOpen);
    }

    public List<String> findStudentWorksId(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen, int start, int size) {
        return this.worksAuthorRepository.findStudentWorksId(brand, puids, suid, isOpen, start, size);
    }

    public List<String> findAllStudentWorksId(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen) {
        return this.worksAuthorRepository.findAllStudentWorksId(brand, puids, suid, isOpen);
    }

    public int countStudentWorksBySuids(BrandEnum brand, Collection<String> suids, Integer isOpen) {
        return this.worksAuthorRepository.countStudentWorksBySuids(brand, suids, isOpen);
    }

    public List<String> findStudentWorksIdBySuids(BrandEnum brand, Collection<String> suids, Integer isOpen, int start, int size) {
        return this.worksAuthorRepository.findStudentWorksIdBySuids(brand, suids, isOpen, start, size);
    }

    public List<String> findAllStudentWorksIdBySuids(BrandEnum brand, Collection<String> suids, Integer isOpen) {
        return this.worksAuthorRepository.findAllStudentWorksIdBySuids(brand, suids, isOpen);
    }

    public List<WorksAuthor> findExistWorksInfo(Map<String, Collection<String>> school2LessonIds, String suid) {
        return this.worksAuthorRepository.findExistWorksInfo(school2LessonIds, suid);
    }

    public String getWorkIdByLesson(String schoolId, String lessonId, String suid) {
        return this.worksAuthorRepository.getWorkIdByLesson(schoolId, lessonId, suid);
    }

    public void updateOpenInfo(String workId, int isOpen) {
        this.worksAuthorRepository.updateOpenInfo(workId, isOpen);
    }

    public void createWorkAuthor(String brandId, String id, String schoolId, String lessonId, String puid, String suid, int isCollective) {
        this.worksAuthorRepository.createWorkAuthor(brandId, id, schoolId, lessonId, puid, suid, isCollective);
    }

    public Map<String, Integer> getStudentWorksCnt(BrandEnum brand, List<String> suids) {
        List<Map<String, Object>> list = this.worksAuthorRepository.getStudentWorksCnt(brand, suids);
        HashMap map = Maps.newHashMap();
        for (Map<String, Object> m : list) {
            map.put(MapUtils.getString(m, (Object)"suid"), MapUtils.getIntValue(m, (Object)"worksCnt"));
        }
        return map;
    }

    public List<WorksAuthor> filterWorksAuthor(String suid, Map<String, Collection<String>> school2Lessons) {
        return this.worksAuthorRepository.filterWorksAuthor(suid, school2Lessons);
    }
}

