package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TestsAttributesRepository;
import com.jz.jooq.media.tables.pojos.TestsAttributes;
import com.jz.jooq.media.tables.pojos.TomatoDirection;

@Lazy
@Service
public class TestsAttributesService {

	@Autowired
	private TestsAttributesRepository testsAttributesRepository;

	public List<TestsAttributes> getAttributesForDirections(Collection<String> directions) {
		return testsAttributesRepository.getAttributesForDirections(directions);
	}
	
	public String getDirectionForAttribute(String attributeId) {
		return testsAttributesRepository.getDirectionForAttribute(attributeId);
	}
	
	public TomatoDirection getDirectionInfo(String direction) {
		return testsAttributesRepository.getDirectionInfo(direction);
	}
}
