package com.jz.jar.media.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCoinChange;

@Lazy
@Repository
public class UserCoinRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCoin UC = Tables.USER_COIN;
	private static final com.jz.jooq.media.tables.UserCoinChange UCC = Tables.USER_COIN_CHANGE;

	public int getUserCurrentCoin(String uid, String brand) {
		Integer coin = mediaCtx.select(UC.COIN).from(UC).where(UC.UID.eq(uid).and(UC.BRAND.eq(brand)))
				.fetchAnyInto(Integer.class);
		return coin != null && coin > 0 ? coin : 0;
	}

	public void updateUserCoin(String uid, String brand, int num) {
		mediaCtx.insertInto(UC, UC.UID, UC.BRAND, UC.COIN).values(uid, brand, num).onDuplicateKeyUpdate()
				.set(UC.COIN, UC.COIN.add(num)).execute();
	}

	public void saveCoinChange(String uid, String brand, int num, String remark) {
		mediaCtx.insertInto(UCC, UCC.UID, UCC.BRAND, UCC.NUM, UCC.REMARK, UCC.CREATE_TIME)
				.values(uid, brand, num, remark, System.currentTimeMillis()).execute();
	}

	public int cntChangeRecords(String uid, String brand, Integer type) {
		return mediaCtx.fetchCount(UCC, this.genWhere(uid, brand, type));
	}

	public List<UserCoinChange> getChangeRecords(String uid, String brand, Integer type, int start, int size) {
		return mediaCtx.select(UCC.NUM, UCC.REMARK, UCC.CREATE_TIME).from(UCC).where(this.genWhere(uid, brand, type))
				.orderBy(UCC.CREATE_TIME.desc()).limit(start, size).fetchInto(UserCoinChange.class);
	}

	private Condition genWhere(String uid, String brand, Integer type) {
		Condition c = UCC.UID.eq(uid).and(UCC.BRAND.eq(brand));
		if (type != null) {
			if (type == 1) { // 1收入 2支出
				c = c.and(UCC.NUM.gt(0));
			} else {
				c = c.and(UCC.NUM.lt(0));
			}
		}
		return c;
	}

}
